/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.ParseException;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.QuasiNode;
import com.google.caja.util.Maps;
import java.util.Map;

public class QuasiCache {
    private static Map<String, QuasiNode> cache = Maps.newHashMap();

    public static QuasiNode parse(String pattern) {
        if (cache.containsKey(pattern)) {
            return cache.get(pattern);
        }
        try {
            QuasiNode q = QuasiBuilder.parseQuasiNode(pattern);
            cache.put(pattern, q);
            return q;
        }
        catch (ParseException e) {
            cache.put(pattern, null);
            return null;
        }
    }
}

