/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.ParserBase;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.quasiliteral.ObjectCtorQuasiNode;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.QuasiCache;
import com.google.caja.parser.quasiliteral.QuasiNode;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.parser.quasiliteral.SimpleQuasiNode;
import com.google.caja.parser.quasiliteral.StringLiteralQuasiNode;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Rule
implements MessagePart {
    public static final ParseTreeNode NONE = new AbstractParseTreeNode(FilePosition.UNKNOWN){
        private static final long serialVersionUID = -2661372462823134153L;

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void render(RenderContext r) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TokenConsumer makeRenderer(Appendable out, Callback<IOException> exHandler) {
            throw new UnsupportedOperationException();
        }
    };
    private final String name;
    private Rewriter rewriter;
    private RuleDescription description;
    private static final Expression[] NO_EXPRS = new Expression[0];

    public Rule() {
        this.name = this.getRuleDescription().name();
    }

    public Rule(String name, Rewriter rewriter) {
        assert (name != null);
        this.name = name;
        this.rewriter = rewriter;
    }

    public String getName() {
        return this.name;
    }

    public Rewriter getRewriter() {
        return this.rewriter;
    }

    public void setRewriter(Rewriter rewriter) {
        assert (this.rewriter == null || this.rewriter == rewriter);
        this.rewriter = rewriter;
    }

    public RuleDescription getRuleDescription() {
        if (this.description == null) {
            Method fire;
            try {
                fire = this.getClass().getMethod("fire", ParseTreeNode.class, Scope.class);
            }
            catch (NoSuchMethodException e) {
                NoSuchMethodError error = new NoSuchMethodError();
                error.initCause(e);
                throw error;
            }
            this.description = fire.getAnnotation(RuleDescription.class);
            if (this.description == null) {
                throw new IllegalStateException("RuleDescription not found");
            }
        }
        return this.description;
    }

    public boolean canMatch(Class<? extends ParseTreeNode> nodeType) {
        RuleDescription desc = this.getRuleDescription();
        Class<? extends ParseTreeNode> bound = desc.matchNode();
        if (bound != ParseTreeNode.class) {
            bound = QuasiBuilder.fuzzType(bound);
        } else {
            String pattern = desc.matches();
            bound = Rule.quasiLowerBound(QuasiCache.parse(pattern));
        }
        return bound.isAssignableFrom(nodeType);
    }

    private static Class<? extends ParseTreeNode> quasiLowerBound(QuasiNode p) {
        if (p == null) {
            return ParseTreeNode.class;
        }
        if (p instanceof SimpleQuasiNode) {
            return QuasiBuilder.fuzzType(((SimpleQuasiNode)p).getMatchedClass());
        }
        if (p instanceof ObjectCtorQuasiNode) {
            return ObjectConstructor.class;
        }
        if (p instanceof StringLiteralQuasiNode) {
            return StringLiteral.class;
        }
        return ParseTreeNode.class;
    }

    public abstract ParseTreeNode fire(ParseTreeNode var1, Scope var2);

    @Override
    public void format(MessageContext mc, Appendable out) throws IOException {
        out.append("Rule \"" + this.name + "\"");
    }

    protected final ParseTreeNode expandAll(ParseTreeNode node, Scope scope) {
        return this.expandAllTo(node, node.getClass(), scope);
    }

    protected final ParseTreeNode expandAllTo(ParseTreeNode node, Class<? extends ParseTreeNode> parentNodeClass, Scope scope) {
        boolean allChildrenSame = true;
        List<ParseTreeNode> rewrittenChildren = Lists.newArrayList();
        for (ParseTreeNode parseTreeNode : node.children()) {
            ParseTreeNode expanded = this.rewriter.expand(parseTreeNode, scope);
            allChildrenSame = allChildrenSame && parseTreeNode == expanded;
            rewrittenChildren.add(expanded);
        }
        if (allChildrenSame) {
            this.rewriter.clearTaint(node);
            return node;
        }
        ParseTreeNode result = ParseTreeNodes.newNodeInstance(parentNodeClass, node.getFilePosition(), node.getValue(), rewrittenChildren);
        result.getAttributes().putAll(node.getAttributes());
        if (SyntheticNodes.is(node)) {
            SyntheticNodes.s(result);
        }
        result.makeImmutable();
        return result;
    }

    static final ParseTreeNode withoutNoops(ParseTreeNode n) {
        if (n instanceof ParseTreeNodeContainer) {
            MutableParseTreeNode.Mutation mut = ((ParseTreeNodeContainer)n).createMutation();
            for (ParseTreeNode parseTreeNode : n.children()) {
                if (!(parseTreeNode instanceof Noop)) continue;
                mut.removeChild(parseTreeNode);
            }
            mut.execute();
        }
        return n;
    }

    public static Reference newReference(FilePosition pos, String name) {
        return new Reference(SyntheticNodes.s(new Identifier(pos, name)));
    }

    protected static ExpressionStmt newExprStmt(Expression e) {
        return new ExpressionStmt(e.getFilePosition(), e);
    }

    private Expression comma(Expression left, Expression right) {
        Map<String, ParseTreeNode> leftBindings = Rule.makeBindings();
        Map<String, ParseTreeNode> rightBindings = Rule.makeBindings();
        if (QuasiBuilder.match("void 0", left)) {
            return right;
        }
        if (QuasiBuilder.match("@leftLeft, void 0", left, leftBindings)) {
            return this.comma((Expression)leftBindings.get("leftLeft"), right);
        }
        if (QuasiBuilder.match("@rightLeft, @rightRight", right, rightBindings)) {
            return this.comma(this.comma(left, (Expression)rightBindings.get("rightLeft")), (Expression)rightBindings.get("rightRight"));
        }
        return Operation.createInfix(Operator.COMMA, left, right);
    }

    protected Expression commas(Expression ... operands) {
        if (operands.length == 0) {
            return Operation.undefined(FilePosition.UNKNOWN);
        }
        Expression result = operands[0];
        for (int i = 1; i < operands.length; ++i) {
            result = this.comma(result, operands[i]);
        }
        return result;
    }

    protected Expression newCommaOperation(List<? extends ParseTreeNode> operands) {
        return this.commas(operands.toArray(NO_EXPRS));
    }

    protected String nym(ParseTreeNode node, String baseName, String ext) {
        String result = node != null && baseName.indexOf("$_") != -1 ? baseName + "$" : baseName + "$_" + ext;
        if (!ParserBase.isJavascriptIdentifier(result)) {
            result = "badName$_" + ext;
        }
        return result;
    }

    protected ParseTreeNode nymize(ParseTreeNode node, String baseName, String ext) {
        Map<String, ParseTreeNode> bindings = Rule.makeBindings();
        if (QuasiBuilder.match("function (@ps*) {@bs*;}", node, bindings)) {
            return QuasiBuilder.substV("function @fname(@ps*) {@bs*;}", "fname", new Identifier(FilePosition.startOf(node.getFilePosition()), this.nym(node, baseName, ext)), "ps", bindings.get("ps"), "bs", bindings.get("bs"));
        }
        return node;
    }

    protected void checkFormals(ParseTreeNode formals) {
        for (ParseTreeNode parseTreeNode : formals.children()) {
            FormalParam f = (FormalParam)parseTreeNode;
            if (Rule.isSynthetic(f.getIdentifier()) || !f.getIdentifierName().endsWith("__")) continue;
            this.rewriter.mq.addMessage((MessageTypeInt)RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE, f.getFilePosition(), this, f);
        }
    }

    protected static boolean isSynthetic(Identifier node) {
        return node.isSynthetic();
    }

    protected static boolean isSynthetic(Reference node) {
        return Rule.isSynthetic(node.getIdentifier());
    }

    protected static boolean isSynthetic(FunctionConstructor node) {
        return node.isSynthetic();
    }

    protected static String getReferenceName(ParseTreeNode ref) {
        return ((Reference)ref).getIdentifierName();
    }

    protected static String getIdentifierName(ParseTreeNode id) {
        return ((Identifier)id).getValue();
    }

    protected static final StringLiteral toStringLiteral(ParseTreeNode node) {
        Identifier ident = node instanceof Reference ? ((Reference)node).getIdentifier() : (node instanceof Declaration ? ((Declaration)node).getIdentifier() : (Identifier)node);
        return new StringLiteral(ident.getFilePosition(), StringLiteral.toQuotedValue(ident.getName()));
    }

    protected Map<String, ParseTreeNode> match(ParseTreeNode node) {
        Map<String, ParseTreeNode> bindings = Rule.makeBindings();
        if (QuasiBuilder.match(this.getRuleDescription().matches(), node, bindings)) {
            return bindings;
        }
        return null;
    }

    protected static Map<String, ParseTreeNode> makeBindings() {
        return Maps.newLinkedHashMap();
    }

    protected ParseTreeNode transform(ParseTreeNode node, Scope scope) {
        Map<String, ParseTreeNode> bindings = this.match(node);
        if (bindings != null) {
            Map<String, ParseTreeNode> newBindings = Rule.makeBindings();
            for (Map.Entry<String, ParseTreeNode> entry : bindings.entrySet()) {
                entry.getValue().makeImmutable();
                newBindings.put(entry.getKey(), this.rewriter.expand(entry.getValue(), scope));
            }
            ParseTreeNode result = QuasiBuilder.subst(this.getRuleDescription().substitutes(), newBindings);
            result.makeImmutable();
            return result;
        }
        return NONE;
    }

    protected ParseTreeNode substV(Object ... args) {
        for (int i = 1; i < args.length; i += 2) {
            if (args[i] == null) continue;
            ((ParseTreeNode)args[i]).makeImmutable();
        }
        ParseTreeNode result = QuasiBuilder.substV(this.getRuleDescription().substitutes(), args);
        result.makeImmutable();
        return result;
    }

    ReadAssignOperands deconstructReadAssignOperand(Expression operand, Scope scope) {
        return this.deconstructReadAssignOperand(operand, scope, true);
    }

    ReadAssignOperands deconstructReadAssignOperand(Expression operand, Scope scope, boolean checkImported) {
        if (operand instanceof Reference) {
            if (checkImported && scope.isImported(((Reference)operand).getIdentifierName())) {
                this.rewriter.mq.addMessage((MessageTypeInt)RewriterMessageType.CANNOT_ASSIGN_TO_FREE_VARIABLE, operand.getFilePosition(), this, operand);
            }
            return this.sideEffectlessReadAssignOperand(operand, scope);
        }
        if (operand instanceof Operation) {
            Operation op = (Operation)operand;
            switch (op.getOperator()) {
                case SQUARE_BRACKET: {
                    return this.sideEffectingReadAssignOperand(op.children().get(0), op.children().get(1), scope);
                }
                case MEMBER_ACCESS: {
                    return this.sideEffectingReadAssignOperand(op.children().get(0), Rule.toStringLiteral(op.children().get(1)), scope);
                }
            }
        }
        throw new IllegalArgumentException("Not an lvalue : " + operand);
    }

    private ReadAssignOperands sideEffectlessReadAssignOperand(Expression lhs, Scope scope) {
        return new ReadAssignOperands(Collections.emptyList(), lhs, (Expression)this.rewriter.expand(lhs, scope));
    }

    private ReadAssignOperands sideEffectingReadAssignOperand(Expression uncajoledObject, Expression uncajoledKey, Scope scope) {
        String keyText;
        Expression key;
        Reference object;
        boolean isKeySimple;
        List<Expression> temporaries = Lists.newArrayList();
        boolean bl = isKeySimple = uncajoledKey instanceof Literal || Rule.isLocalReference(uncajoledKey, scope);
        if (isKeySimple && (Rule.isLocalReference(uncajoledObject, scope) || Rule.isImportsReference(uncajoledObject))) {
            object = (Reference)uncajoledObject;
        } else {
            Reference tmpVar = scope.declareStartOfScopeTemp();
            temporaries.add((Expression)QuasiBuilder.substV("@tmpVar = @left;", "tmpVar", tmpVar, "left", this.rewriter.expand(uncajoledObject, scope)));
            object = tmpVar;
        }
        if (isKeySimple) {
            key = uncajoledKey;
        } else {
            ParseTreeNode rightExpanded = this.rewriter.expand(uncajoledKey, scope);
            Reference tmpVar = scope.declareStartOfScopeTemp();
            key = tmpVar;
            if (QuasiBuilder.match("@s&(-1>>>1)", rightExpanded)) {
                key = (Expression)QuasiBuilder.substV("@key&(-1>>>1)", "key", key);
            }
            temporaries.add((Expression)QuasiBuilder.substV("@tmpVar = @right;", "tmpVar", tmpVar, "right", rightExpanded));
        }
        Operation propertyAccess = null;
        if (key instanceof StringLiteral && ParserBase.isJavascriptIdentifier(keyText = ((StringLiteral)key).getUnquotedValue()) && Keyword.fromString(keyText) == null) {
            Reference ident = new Reference(new Identifier(key.getFilePosition(), keyText));
            propertyAccess = Operation.create(FilePosition.span(object.getFilePosition(), key.getFilePosition()), Operator.MEMBER_ACCESS, object, ident);
        }
        if (propertyAccess == null) {
            propertyAccess = Operation.create(FilePosition.span(object.getFilePosition(), key.getFilePosition()), Operator.SQUARE_BRACKET, object, key);
        }
        return new ReadAssignOperands(temporaries, propertyAccess, (Expression)this.rewriter.expand(propertyAccess, scope));
    }

    private static boolean isLocalReference(Expression e, Scope scope) {
        return e instanceof Reference && !scope.isImported(((Reference)e).getIdentifierName());
    }

    private static boolean isImportsReference(Expression e) {
        if (!(e instanceof Reference)) {
            return false;
        }
        return "IMPORTS___".equals(((Reference)e).getIdentifierName());
    }

    public String toString() {
        return "<Rule " + this.getName() + ">";
    }

    protected final class Reusable {
        private final Scope scope;
        private ParseTreeNode[] expressions;
        private Expression[] refs;
        private Expression[] inits;

        public Reusable(Scope scope, ParseTreeNode ... expressions) {
            this.scope = scope;
            this.expressions = expressions;
        }

        public void addChildren(ParseTreeNode list) {
            int n = list.children().size();
            int oldSize = this.expressions.length;
            this.expressions = Arrays.copyOf(this.expressions, oldSize + n);
            for (int i = 0; i < n; ++i) {
                this.expressions[oldSize + i] = list.children().get(i);
            }
        }

        public Reusable generate() {
            int i;
            this.refs = new Expression[this.expressions.length];
            this.inits = new Expression[this.expressions.length];
            boolean needTemps = false;
            for (i = 0; i < this.expressions.length; ++i) {
                Expression value = (Expression)Rule.this.rewriter.expand(this.expressions[i], this.scope);
                if (this.canWeaklyReuse(value)) {
                    this.refs[i] = value;
                    this.inits[i] = null;
                    continue;
                }
                needTemps = true;
                this.makeTemp(i, value);
            }
            for (i = 0; i < this.expressions.length; ++i) {
                if (this.inits[i] != null) continue;
                if (needTemps && !this.canAlwaysReuse(this.refs[i])) {
                    this.makeTemp(i, this.refs[i]);
                    continue;
                }
                this.inits[i] = Operation.undefined(FilePosition.UNKNOWN);
            }
            return this;
        }

        public Expression init() {
            return Rule.this.commas(this.inits);
        }

        public Expression ref(int i) {
            return this.refs[i];
        }

        public ParseTreeNodeContainer refListFrom(int i) {
            return new ParseTreeNodeContainer(Arrays.asList(Arrays.copyOfRange(this.refs, i, this.refs.length)));
        }

        private void makeTemp(int i, Expression value) {
            Reference temp = this.scope.declareStartOfScopeTemp();
            this.refs[i] = temp;
            this.inits[i] = (Expression)QuasiBuilder.substV("@temp = @value", "temp", temp, "value", value);
        }

        private boolean canWeaklyReuse(Expression e) {
            return e instanceof Literal || e instanceof Reference;
        }

        private boolean canAlwaysReuse(Expression e) {
            return e instanceof Literal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ReadAssignOperands {
        private final List<Expression> temporaries;
        private final Expression uncajoled;
        private final Expression cajoled;

        private ReadAssignOperands(List<Expression> temporaries, Expression lhs, Expression rhs) {
            assert (lhs.isLeftHandSide());
            this.temporaries = temporaries;
            this.uncajoled = lhs;
            this.cajoled = rhs;
        }

        public List<Expression> getTemporaries() {
            return this.temporaries;
        }

        public ParseTreeNodeContainer getTemporariesAsContainer() {
            return new ParseTreeNodeContainer(this.temporaries);
        }

        public Expression getUncajoledLValue() {
            return this.uncajoled;
        }

        public Expression getCajoledLValue() {
            return this.cajoled;
        }

        public boolean isSimpleLValue() {
            return this.temporaries.isEmpty() && this.cajoled.isLeftHandSide() && this.cajoled instanceof Reference;
        }

        public Operation makeAssignment(Expression rhs) {
            Operation e = Operation.createInfix(Operator.ASSIGN, this.uncajoled, rhs);
            Rule.this.rewriter.setTaint(e);
            return e;
        }
    }
}

