/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.ExternalReference;
import com.google.caja.plugin.LoaderType;
import com.google.caja.plugin.UriEffect;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.plugin.UriToFile;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileSystemUriPolicy
implements UriPolicy {
    private final UriToFile uriToFile;

    FileSystemUriPolicy(UriToFile uriToFile) {
        this.uriToFile = uriToFile;
    }

    private URI refragUri(URI uri, String frag) throws URISyntaxException {
        return new URI(uri.getScheme(), uri.getSchemeSpecificPart(), frag);
    }

    @Override
    public String rewriteUri(ExternalReference u, UriEffect effect, LoaderType loader, Map<String, ?> hints) {
        URI uri = u.getUri();
        try {
            URI fragless = this.refragUri(uri, null);
            File f = this.uriToFile.apply(fragless);
            if (f != null) {
                URI base = new File(this.uriToFile.directory, ".").toURI();
                URI rel = base.relativize(fragless);
                return this.refragUri(rel, uri.getFragment()).toString();
            }
            URI self = u.getReferencePosition().source().getUri();
            String uristr = self.relativize(uri).toString();
            if (uristr.startsWith("#")) {
                return uristr;
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        return null;
    }
}

