/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.util.Lists;
import com.google.caja.util.Multimap;
import com.google.caja.util.Multimaps;
import com.google.caja.util.Pipeline;
import java.util.ListIterator;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ParametersAreNonnullByDefault
public final class PipelineStoreStage
implements Pipeline.Stage<Jobs> {
    private final JobCache cache;

    public PipelineStoreStage(JobCache cache) {
        this.cache = cache;
    }

    @Override
    public boolean apply(Jobs jobs) {
        Multimap<JobCache.Key, Job> byKey = Multimaps.newListHashMultimap();
        ListIterator<JobEnvelope> it = jobs.getJobs().listIterator();
        while (it.hasNext()) {
            JobEnvelope env = it.next();
            if (!env.fromCache) {
                for (JobCache.Key key : env.cacheKeys) {
                    byKey.put(key, env.job);
                }
            }
            if (!env.fromCache && !env.cacheKeys.iterator().hasNext()) continue;
            it.set(new JobEnvelope(env.placeholderId, JobCache.none(), env.sourceType, false, env.job));
        }
        for (JobCache.Key key : byKey.keySet()) {
            this.cache.store(key, Lists.newArrayList(byKey.get(key)));
        }
        return jobs.hasNoFatalErrors();
    }
}

