/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.plugin.ExpressionSanitizerCaja;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.util.ContentType;
import com.google.caja.util.Maps;
import com.google.caja.util.Pipeline;
import java.net.URI;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidateJavascriptStage
implements Pipeline.Stage<Jobs> {
    private final ModuleManager mgr;

    public ValidateJavascriptStage(ModuleManager mgr) {
        this.mgr = mgr;
    }

    @Override
    public boolean apply(Jobs jobs) {
        Map<String, JobCache.Keys> keys = Maps.newHashMap();
        ListIterator<JobEnvelope> it = jobs.getJobs().listIterator();
        while (it.hasNext()) {
            ArrayConstructor deps;
            Statement s;
            Job job;
            JobEnvelope env = it.next();
            if (env.fromCache || (job = env.job).getType() != ContentType.JS) continue;
            URI baseUri = job.getBaseUri();
            ParseTreeNode result = new ExpressionSanitizerCaja(this.mgr, baseUri).sanitize(UncajoledModule.of(s = (Statement)job.getRoot()));
            if (!(result instanceof CajoledModule)) {
                it.remove();
                continue;
            }
            CajoledModule validated = (CajoledModule)result;
            it.set(env.withJob(Job.cajoledJob(validated)));
            if (!env.cacheKeys.iterator().hasNext() || (deps = validated.getInlinedModules()) == null) continue;
            for (Expression expression : deps.children()) {
                String moduleUri = ((StringLiteral)expression).getUnquotedValue();
                JobCache.Keys forUri = (JobCache.Keys)keys.get(moduleUri);
                forUri = forUri == null ? env.cacheKeys : forUri.union(env.cacheKeys);
                keys.put(moduleUri, env.cacheKeys);
            }
        }
        return jobs.hasNoFatalErrors();
    }
}

