/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lang.html.HTML;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Nodes;
import com.google.caja.plugin.templates.IHTML;
import com.google.caja.plugin.templates.IhtmlMessageType;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IhtmlSanityChecker {
    private final MessageQueue mq;
    private static final String BROKEN_NODE = "broken_node";

    public IhtmlSanityChecker(MessageQueue mq) {
        assert (mq != null);
        this.mq = mq;
    }

    public boolean check(Node node) {
        if (node.getNodeType() == 1) {
            return this.check((Element)node);
        }
        boolean ok = true;
        for (Node node2 : Nodes.childrenOf(node)) {
            ok &= this.check(node2);
        }
        return ok;
    }

    public boolean check(Element ihtmlRoot) {
        this.checkIhtmlElements(ihtmlRoot);
        this.checkDynamicDomParents(ihtmlRoot);
        this.disallowNestedMessages(ihtmlRoot);
        this.disallowPlaceholderContent(ihtmlRoot);
        this.disallowIhtmlInMessageOutsidePlaceholders(ihtmlRoot, false);
        this.checkPlaceholdersBalanced(ihtmlRoot);
        this.removeBrokenNodes(ihtmlRoot);
        return !IhtmlSanityChecker.isBroken(ihtmlRoot);
    }

    private void checkIhtmlElements(Element ihtmlRoot) {
        for (Element ihtmlEl : IhtmlSanityChecker.allIhtml(ihtmlRoot)) {
            AttribKey attrKey;
            ElKey elKey = ElKey.forElement(ihtmlEl);
            if (!IHTML.SCHEMA.isElementAllowed(elKey)) {
                this.mq.addMessage((MessageTypeInt)IhtmlMessageType.BAD_ELEMENT, Nodes.getFilePositionFor(ihtmlEl), elKey);
                IhtmlSanityChecker.markBroken(ihtmlEl);
                continue;
            }
            HTML.Element elDetails = IHTML.SCHEMA.lookupElement(elKey);
            for (HTML.Attribute attribute : elDetails.getAttributes()) {
                if (attribute.isOptional()) continue;
                attrKey = attribute.getKey();
                if (ihtmlEl.hasAttributeNS(attrKey.ns.uri, attrKey.localName)) continue;
                this.mq.addMessage((MessageTypeInt)IhtmlMessageType.MISSING_ATTRIB, Nodes.getFilePositionFor(ihtmlEl), elKey, attrKey);
                IhtmlSanityChecker.markBroken(ihtmlEl);
            }
            for (Attr attr : Nodes.attributesOf(ihtmlEl)) {
                attrKey = AttribKey.forAttribute(elKey, attr);
                if (IHTML.is(ihtmlEl, "call") && IHTML.is(attrKey.ns) && IHTML.isSafeIdentifier(attr.getName())) continue;
                HTML.Attribute attrDetails = IHTML.SCHEMA.lookupAttribute(attrKey);
                if (IHTML.SCHEMA.isAttributeAllowed(attrKey) && attrDetails.getValueCriterion().accept(attr.getValue())) continue;
                this.mq.addMessage((MessageTypeInt)IhtmlMessageType.BAD_ATTRIB, IhtmlSanityChecker.posOf(attr), elKey, attrKey, MessagePart.Factory.valueOf(attr.getValue()));
                IhtmlSanityChecker.markBroken(ihtmlEl);
            }
        }
    }

    private void checkDynamicDomParents(Element ihtmlRoot) {
        for (String elementName : new String[]{"attribute", "element"}) {
            for (Element iel : IHTML.allOf(ihtmlRoot, elementName)) {
                Node p = iel;
                while ((p = p.getParentNode()) != null) {
                    if (!IHTML.isIhtml(p) || IHTML.isTemplate(p) || IHTML.isDo(p) || IHTML.isElse(p)) continue;
                    this.mq.addMessage((MessageTypeInt)IhtmlMessageType.MISPLACED_ELEMENT, Nodes.getFilePositionFor(iel), MessagePart.Factory.valueOf(iel.getNodeName()), MessagePart.Factory.valueOf(p.getNodeName()));
                    IhtmlSanityChecker.markBroken(iel);
                }
            }
        }
    }

    private void disallowNestedMessages(Element ihtmlRoot) {
        Iterator<Element> i$ = IHTML.allOf(ihtmlRoot, "message").iterator();
        while (i$.hasNext()) {
            Element msg;
            Node p = msg = i$.next();
            while ((p = p.getParentNode()) != null) {
                if (!IHTML.isMessage(p)) continue;
                this.mq.addMessage((MessageTypeInt)IhtmlMessageType.NESTED_MESSAGE, Nodes.getFilePositionFor(msg), Nodes.getFilePositionFor(p));
                IhtmlSanityChecker.markBroken(msg);
            }
        }
    }

    private void disallowPlaceholderContent(Element ihtmlRoot) {
        for (Element element : IHTML.getPlaceholders(ihtmlRoot)) {
            if (element.getFirstChild() == null) continue;
            this.mq.addMessage((MessageTypeInt)IhtmlMessageType.INAPPROPRIATE_CONTENT, FilePosition.span(Nodes.getFilePositionFor(element.getFirstChild()), Nodes.getFilePositionFor(element.getLastChild())), MessagePart.Factory.valueOf(element.getLocalName()));
            IhtmlSanityChecker.markBroken(element);
        }
    }

    private void checkPlaceholdersBalanced(Element ihtmlRoot) {
        boolean expectOpen = true;
        Element last = null;
        Node lastContainer = null;
        for (Element element : IHTML.getPlaceholders(ihtmlRoot)) {
            if (IhtmlSanityChecker.isBroken(element)) continue;
            Node msg = null;
            Node p = element;
            while ((p = p.getParentNode()) != null) {
                if (IHTML.isMessage(p)) {
                    msg = p;
                    break;
                }
                if (!IhtmlSanityChecker.isIhtml(p)) continue;
            }
            if (msg == null) {
                this.mq.addMessage((MessageTypeInt)IhtmlMessageType.ORPHANED_PLACEHOLDER, Nodes.getFilePositionFor(element));
                IhtmlSanityChecker.markBroken(element);
                continue;
            }
            if (msg != lastContainer) {
                if (!expectOpen) {
                    assert (lastContainer != null);
                    IhtmlSanityChecker.markBroken(last);
                    FilePosition endPos = FilePosition.endOf(Nodes.getFilePositionFor(lastContainer.getLastChild()));
                    this.mq.addMessage((MessageTypeInt)IhtmlMessageType.UNCLOSED_PLACEHOLDER, FilePosition.span(Nodes.getFilePositionFor(last), endPos));
                    IhtmlSanityChecker.markBroken(last);
                    expectOpen = true;
                    last = null;
                }
                lastContainer = msg;
            }
            if (expectOpen != IHTML.isPh(element)) {
                if (expectOpen) {
                    this.mq.addMessage((MessageTypeInt)IhtmlMessageType.ORPHANED_PLACEHOLDER_END, Nodes.getFilePositionFor(element));
                    IhtmlSanityChecker.markBroken(element);
                    continue;
                }
                this.mq.addMessage((MessageTypeInt)IhtmlMessageType.UNCLOSED_PLACEHOLDER, FilePosition.span(Nodes.getFilePositionFor(last), FilePosition.startOf(Nodes.getFilePositionFor(element))));
                IhtmlSanityChecker.markBroken(last);
                last = element;
                continue;
            }
            last = element;
            expectOpen = !expectOpen;
        }
        if (!expectOpen) {
            assert (lastContainer != null);
            FilePosition endPos = FilePosition.endOf(Nodes.getFilePositionFor(lastContainer.getLastChild()));
            this.mq.addMessage((MessageTypeInt)IhtmlMessageType.UNCLOSED_PLACEHOLDER, FilePosition.span(Nodes.getFilePositionFor(last), endPos));
            IhtmlSanityChecker.markBroken(last);
        }
    }

    private void disallowIhtmlInMessageOutsidePlaceholders(Element el, boolean inMessage) {
        if (IhtmlSanityChecker.isBroken(el)) {
            return;
        }
        if (IhtmlSanityChecker.isIhtml(el)) {
            if (IHTML.isMessage(el)) {
                inMessage = true;
            } else if (inMessage) {
                this.mq.addMessage((MessageTypeInt)IhtmlMessageType.IHTML_IN_MESSAGE_OUTSIDE_PLACEHOLDER, Nodes.getFilePositionFor(el), MessagePart.Factory.valueOf(el.getLocalName()));
                Node p = el;
                while ((p = p.getParentNode()) != null) {
                    if (!IHTML.isMessage(p)) continue;
                    IhtmlSanityChecker.markBroken(p);
                    break;
                }
            }
        }
        boolean inPlaceholder = false;
        for (Node c = el.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (!(c instanceof Element)) continue;
            Element cEl = (Element)c;
            if (IHTML.isPh(cEl)) {
                inPlaceholder = inMessage;
                continue;
            }
            if (IHTML.isEph(cEl)) {
                inPlaceholder = false;
                continue;
            }
            if (inPlaceholder) continue;
            this.disallowIhtmlInMessageOutsidePlaceholders(cEl, inMessage);
        }
    }

    private void removeBrokenNodes(Element ihtmlRoot) {
        ArrayList<Element> broken = new ArrayList<Element>();
        for (Element e : Nodes.nodeListIterable(ihtmlRoot.getElementsByTagName("*"), Element.class)) {
            if (!IhtmlSanityChecker.isBroken(e)) continue;
            broken.add(e);
        }
        for (Element e : broken) {
            e.getParentNode().removeChild(e);
        }
    }

    private static void markBroken(Node node) {
        node.setUserData(BROKEN_NODE, Boolean.TRUE, null);
    }

    private static boolean isBroken(Node node) {
        return Boolean.TRUE.equals(node.getUserData(BROKEN_NODE));
    }

    private static boolean isIhtml(Node node) {
        return node instanceof Element && IHTML.NAMESPACE.equals(node.getNamespaceURI());
    }

    private static Iterable<Element> allIhtml(Element root) {
        return Nodes.nodeListIterable(root.getElementsByTagNameNS(IHTML.NAMESPACE, "*"), Element.class);
    }

    private static FilePosition posOf(Attr a) {
        return FilePosition.span(Nodes.getFilePositionFor(a), Nodes.getFilePositionForValue(a));
    }
}

