/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HTML;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Placeholder;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.stages.EmbeddedContent;
import com.google.caja.plugin.stages.HtmlEmbeddedContentFinder;
import com.google.caja.plugin.templates.HtmlAttributeRewriter;
import com.google.caja.plugin.templates.IhtmlMessageType;
import com.google.caja.plugin.templates.IhtmlRoot;
import com.google.caja.plugin.templates.SafeCssMaker;
import com.google.caja.plugin.templates.SafeHtmlChunk;
import com.google.caja.plugin.templates.SafeHtmlMaker;
import com.google.caja.plugin.templates.SafeJsChunk;
import com.google.caja.plugin.templates.SafeStylesheet;
import com.google.caja.plugin.templates.ScriptPlaceholder;
import com.google.caja.plugin.templates.ValidatedStylesheet;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Pair;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCompiler {
    private final List<IhtmlRoot> ihtmlRoots;
    private final List<ValidatedStylesheet> validatedStylesheets;
    private final HtmlSchema htmlSchema;
    private final PluginMeta meta;
    private final MessageContext mc;
    private final MessageQueue mq;
    private final HtmlAttributeRewriter aRewriter;
    public static final String ATTRIBUTE_VALUE_WAS_UNSPECIFIED = "ATTRIBUTE_VALUE_WAS_UNSPECIFIED";
    private final Map<Node, ParseTreeNode> scriptsPerNode = Maps.newIdentityHashMap();
    private final Map<String, ScriptPlaceholder> scriptsPerPlaceholder = Maps.newHashMap();
    private final Map<Attr, EmbeddedContent> embeddedContent = Maps.newIdentityHashMap();

    public TemplateCompiler(List<? extends IhtmlRoot> ihtmlRoots, List<? extends ValidatedStylesheet> validatedStylesheets, List<? extends ScriptPlaceholder> placeholderScripts, CssSchema cssSchema, HtmlSchema htmlSchema, PluginMeta meta, MessageContext mc, MessageQueue mq) {
        this.ihtmlRoots = Lists.newArrayList(ihtmlRoots);
        this.validatedStylesheets = Lists.newArrayList(validatedStylesheets);
        for (ScriptPlaceholder scriptPlaceholder : placeholderScripts) {
            this.scriptsPerPlaceholder.put(scriptPlaceholder.source.placeholderId, scriptPlaceholder);
        }
        this.htmlSchema = htmlSchema;
        this.meta = meta;
        this.mc = mc;
        this.mq = mq;
        this.aRewriter = new HtmlAttributeRewriter(meta, cssSchema, htmlSchema, this.embeddedContent, mq);
    }

    private void inspect() {
        if (!this.mq.hasMessageAtLevel(MessageLevel.FATAL_ERROR)) {
            for (IhtmlRoot ihtmlRoot : this.ihtmlRoots) {
                HtmlEmbeddedContentFinder finder = new HtmlEmbeddedContentFinder(this.htmlSchema, ihtmlRoot.baseUri, this.mq, this.mc);
                for (EmbeddedContent c : finder.findEmbeddedContent(ihtmlRoot.root)) {
                    Node src = c.getSource();
                    if (!(src instanceof Attr)) continue;
                    this.embeddedContent.put((Attr)src, c);
                }
                this.inspect(ihtmlRoot.source, ihtmlRoot.root, ElKey.forHtmlElement("div"));
            }
        }
    }

    private void inspect(JobEnvelope source, Node n, ElKey containingHtmlElement) {
        switch (n.getNodeType()) {
            case 1: {
                this.inspectElement(source, (Element)n, containingHtmlElement);
                break;
            }
            case 3: 
            case 4: {
                this.inspectText((Text)n, containingHtmlElement);
                break;
            }
            case 11: {
                this.inspectFragment(source, (DocumentFragment)n, containingHtmlElement);
                break;
            }
        }
    }

    private void inspectElement(JobEnvelope source, Element el, ElKey containingHtmlElement) {
        Attr attr;
        ElKey elKey = ElKey.forElement(el);
        for (Node node : Nodes.childrenOf(el)) {
            this.inspect(source, node, elKey);
        }
        if (!this.htmlSchema.isElementAllowed(elKey)) {
            return;
        }
        HTML.Element elInfo = this.htmlSchema.lookupElement(elKey);
        List<HTML.Attribute> list = elInfo.getAttributes();
        if (list != null) {
            for (HTML.Attribute a : list) {
                AttribKey attrKey = a.getKey();
                if (!this.htmlSchema.isAttributeAllowed(attrKey)) continue;
                attr = null;
                String aUri = attrKey.ns.uri;
                String aName = attrKey.localName;
                Attr unsafe = el.getAttributeNodeNS(aUri, aName);
                if (a.getType() == HTML.Attribute.Type.FRAME_TARGET) {
                    if (unsafe == null) {
                        attr = el.getOwnerDocument().createAttributeNS(attrKey.ns.uri, attrKey.localName);
                        attr.setNodeValue("");
                        attr.setUserData(ATTRIBUTE_VALUE_WAS_UNSPECIFIED, true, null);
                        el.setAttributeNode(attr);
                    } else {
                        attr = unsafe;
                    }
                } else if (unsafe != null && a.getValueCriterion().accept(unsafe.getValue())) {
                    attr = unsafe;
                } else if (a.getDefaultValue() != null && !a.getValueCriterion().accept(a.getDefaultValue()) || !a.isOptional()) {
                    attr = el.getOwnerDocument().createAttributeNS(aUri, aName);
                    String safeValue = a.getType() == HTML.Attribute.Type.URI ? "" + Nodes.getFilePositionFor(el).source().getUri() : (unsafe == null && a.getDefaultValue() != null && a.getValueCriterion().accept(a.getDefaultValue()) ? a.getDefaultValue() : a.getSafeValue());
                    if (safeValue == null) {
                        this.mq.addMessage((MessageTypeInt)IhtmlMessageType.MISSING_ATTRIB, Nodes.getFilePositionFor(el), elKey, attrKey);
                        continue;
                    }
                    attr.setNodeValue(safeValue);
                    el.setAttributeNodeNS(attr);
                }
                if (attr == null) continue;
                this.inspectHtmlAttribute(source, attr, a);
            }
        }
        NamedNodeMap attrMap = el.getAttributes();
        int attrLen = attrMap.getLength();
        for (int i = 0; i < attrLen; ++i) {
            attr = (Attr)attrMap.item(i);
            if (!attr.getLocalName().startsWith("data-caja-")) continue;
            this.scriptsPerNode.put(attr, new StringLiteral(Nodes.getFilePositionForValue(attr), attr.getValue()));
        }
        this.scriptsPerNode.put(el, null);
    }

    private void inspectText(Text t, ElKey containingHtmlElement) {
        if (!this.htmlSchema.isElementAllowed(containingHtmlElement)) {
            return;
        }
        this.scriptsPerNode.put(t, null);
    }

    private void inspectFragment(JobEnvelope source, DocumentFragment f, ElKey containingHtmlElement) {
        this.scriptsPerNode.put(f, null);
        for (Node node : Nodes.childrenOf(f)) {
            if (TemplateCompiler.isWhitespaceOnlyTextNode(node)) continue;
            this.inspect(source, node, containingHtmlElement);
        }
    }

    private static boolean isWhitespaceOnlyTextNode(Node child) {
        return child.getNodeType() == 3 && "".equals(child.getNodeValue().replaceAll("[\r\n]+[ \t]*", ""));
    }

    private void inspectHtmlAttribute(JobEnvelope source, Attr attr, HTML.Attribute info) {
        if (attr != null && Placeholder.ID_ATTR.is(attr) && this.scriptsPerPlaceholder.containsKey(attr.getValue())) {
            this.scriptsPerNode.put(attr, null);
        } else {
            HtmlAttributeRewriter.SanitizedAttr r = this.aRewriter.sanitizeStringValue(HtmlAttributeRewriter.fromAttr(attr, info, source));
            if (r.isSafe) {
                this.scriptsPerNode.put(attr, r.result);
            }
        }
    }

    public Pair<List<SafeHtmlChunk>, List<SafeJsChunk>> getSafeHtml(Document doc) {
        this.inspect();
        List<SafeStylesheet> css = new SafeCssMaker(this.validatedStylesheets, doc).make();
        SafeHtmlMaker htmlMaker = new SafeHtmlMaker(this.meta, this.htmlSchema, this.mc, doc, this.scriptsPerNode, this.scriptsPerPlaceholder, this.ihtmlRoots, this.aRewriter.getHandlers());
        return htmlMaker.make(css);
    }
}

