/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsRenderUtil;
import com.google.caja.render.JsTokenAdjacencyChecker;
import com.google.caja.render.TokenClassification;
import com.google.caja.util.Lists;
import java.util.List;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BufferingRenderer
implements TokenConsumer {
    private final List<Object> pending = Lists.newArrayList();
    private final Concatenator out;

    BufferingRenderer(Concatenator out) {
        this.out = out;
    }

    @Override
    public final void noMoreTokens() {
        JsTokenAdjacencyChecker adjChecker = new JsTokenAdjacencyChecker();
        String lastToken = null;
        boolean noOutputWritten = true;
        List<String> outputTokens = this.splitTokens(this.pending);
        this.pending.clear();
        String pendingSpace = null;
        int nTokens = outputTokens.size();
        for (int i = 0; i < nTokens; ++i) {
            String token = outputTokens.get(i);
            if (token.charAt(0) == '\n' || " ".equals(token)) {
                pendingSpace = token;
                continue;
            }
            if (TokenClassification.isComment(token)) {
                String nextToken = null;
                block4: for (int j = i + 1; j < nTokens; ++j) {
                    switch (TokenClassification.classify(outputTokens.get(j))) {
                        case SPACE: 
                        case LINEBREAK: 
                        case COMMENT: {
                            continue block4;
                        }
                        default: {
                            nextToken = outputTokens.get(j);
                            break block4;
                        }
                    }
                }
                if (!JsRenderUtil.canBreakBetween(lastToken, nextToken)) {
                    token = BufferingRenderer.removeLinebreaksFromComment(token);
                    if (pendingSpace != null) {
                        pendingSpace = " ";
                    }
                }
            }
            boolean needSpaceBefore = adjChecker.needSpaceBefore(token);
            if (pendingSpace == null && needSpaceBefore) {
                pendingSpace = " ";
            }
            if (pendingSpace != null) {
                if (pendingSpace.charAt(0) == '\n') {
                    if (!JsRenderUtil.canBreakBetween(lastToken, token)) {
                        pendingSpace = " ";
                    } else if (noOutputWritten) {
                        pendingSpace = pendingSpace.substring(1);
                    }
                }
                this.out.append(pendingSpace);
                pendingSpace = null;
            }
            this.out.append(token);
            noOutputWritten = false;
            if (TokenClassification.isComment(token)) continue;
            lastToken = token;
        }
        this.out.noMoreTokens();
    }

    @Override
    public final void consume(String text) {
        if ("".equals(text)) {
            return;
        }
        this.pending.add(text);
    }

    @Override
    public final void mark(@Nullable FilePosition mark) {
        if (mark != null && !InputSource.UNKNOWN.equals(mark.source())) {
            this.pending.add(mark);
        }
    }

    private static String removeLinebreaksFromComment(String token) {
        int i;
        if (TokenClassification.isLineComment(token)) {
            token = "/*" + token.substring(2) + "*/";
        }
        StringBuilder sb = new StringBuilder(token);
        int i2 = sb.length();
        while (--i2 >= 0) {
            if (!JsLexer.isJsLineSeparator(sb.charAt(i2))) continue;
            sb.setCharAt(i2, ' ');
        }
        int e = sb.length() - 3;
        while ((i = sb.lastIndexOf("*/", e)) >= 0) {
            sb.setCharAt(i + 1, ' ');
        }
        return sb.toString();
    }

    abstract List<String> splitTokens(List<Object> var1);
}

