/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.SnippetProducer;
import java.io.IOException;
import java.util.Map;

public class HtmlSnippetProducer
extends SnippetProducer {
    public HtmlSnippetProducer(Map<InputSource, ? extends CharSequence> originalSrc, MessageContext mc) {
        super(originalSrc, mc);
    }

    @Override
    protected void formatSnippet(FilePosition errorPosition, FilePosition snippetPos, CharSequence line, int start, int end, Appendable out) throws IOException {
        this.formatFilePosition(errorPosition, out);
        out.append(": ").append(HtmlSnippetProducer.html(line.subSequence(0, start))).append("<span class=\"problem\">").append(HtmlSnippetProducer.html(line.subSequence(start, end))).append("</span>").append(HtmlSnippetProducer.html(line.subSequence(end, line.length())));
    }

    @Override
    protected void formatFilePosition(FilePosition pos, Appendable out) throws IOException {
        StringBuilder filename = new StringBuilder();
        pos.source().format(this.mc, filename);
        out.append("<a href=\"#\" class=\"filepos nocode\" onclick=\"selectLine(").append(HtmlSnippetProducer.html(HtmlSnippetProducer.js(pos.source().getUri().toString()))).append(",").append(String.valueOf(pos.startLineNo())).append(",").append(String.valueOf(pos.startCharInLine())).append(",").append(String.valueOf(pos.endLineNo())).append(",").append(String.valueOf(pos.endCharInLine())).append(")\">").append(HtmlSnippetProducer.html(filename)).append(":").append(String.valueOf(pos.startLineNo())).append("</a>");
    }

    private static String html(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        Escaping.escapeXml(s, false, sb);
        return sb.toString();
    }

    private static String js(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        Escaping.escapeJsString(s, false, true, sb);
        sb.append('\'');
        return sb.toString();
    }
}

