/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.service.AbstractCajolingHandler;
import com.google.caja.service.CajolingService;
import com.google.caja.service.ContentHandlerArgs;
import com.google.caja.service.ContentTypeCheck;
import com.google.caja.service.UnsupportedContentTypeException;
import com.google.caja.util.Charsets;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pair;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyHandler
extends AbstractCajolingHandler {
    public ProxyHandler(BuildInfo buildInfo, UriFetcher uriFetcher) {
        super(buildInfo, null, uriFetcher);
    }

    @Override
    public boolean canHandle(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directives, String inputContentType, ContentTypeCheck checker) {
        return (checker.check("text/css", inputContentType) || checker.check("text/javascript", inputContentType)) && transform == CajolingService.Transform.PROXY;
    }

    @Override
    public Pair<String, String> apply(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directives, ContentHandlerArgs args, String inputContentType, ContentTypeCheck checker, FetchedData input, OutputStream response, MessageQueue mq) throws UnsupportedContentTypeException {
        Pair<ContentType, String> contentParams = ProxyHandler.getReturnedContentParams(args);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(response, Charsets.UTF_8);
            FetchedData result = this.uriFetcher.fetch(new ExternalReference(uri, uri, uri, FilePosition.startOfFile(new InputSource(uri))), "*/*");
            if (checker.check("text/css", result.getContentType()) || checker.check("text/javascript", result.getContentType())) {
                ProxyHandler.renderAsJSON(result.getTextualContent().toString(), null, (String)contentParams.b, mq, (Appendable)writer, true);
                writer.flush();
                return Pair.pair(result.getContentType(), result.getCharSet());
            }
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        catch (UriFetcher.UriFetchException ex) {
            return null;
        }
        catch (IOException e) {
            throw new UnsupportedContentTypeException();
        }
    }
}

