/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.tools;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.GoogleCodingConvention;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.jscomp.ant.AntErrorManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureCompiler {
    private static DiagnosticGroup[] diagnosticGroups = new DiagnosticGroup[]{DiagnosticGroups.ACCESS_CONTROLS, DiagnosticGroups.AMBIGUOUS_FUNCTION_DECL, DiagnosticGroups.CHECK_PROVIDES, DiagnosticGroups.CHECK_REGEXP, DiagnosticGroups.CHECK_TYPES, DiagnosticGroups.CHECK_USELESS_CODE, DiagnosticGroups.CHECK_VARIABLES, DiagnosticGroups.CONST, DiagnosticGroups.CONSTANT_PROPERTY, DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT, DiagnosticGroups.DEPRECATED, DiagnosticGroups.DUPLICATE_MESSAGE, DiagnosticGroups.DUPLICATE_VARS, DiagnosticGroups.ES5_STRICT, DiagnosticGroups.EXTERNS_VALIDATION, DiagnosticGroups.FILEOVERVIEW_JSDOC, DiagnosticGroups.GLOBAL_THIS, DiagnosticGroups.INTERNET_EXPLORER_CHECKS, DiagnosticGroups.INVALID_CASTS, DiagnosticGroups.MISSING_PROPERTIES, DiagnosticGroups.NON_STANDARD_JSDOC, DiagnosticGroups.STRICT_MODULE_DEP_CHECK, DiagnosticGroups.TWEAKS, DiagnosticGroups.TYPE_INVALIDATION, DiagnosticGroups.UNDEFINED_NAMES, DiagnosticGroups.UNDEFINED_VARIABLES, DiagnosticGroups.UNKNOWN_DEFINES, DiagnosticGroups.VISIBILITY};

    public String build(Task task, List<File> inputs, PrintWriter logger) {
        List externs;
        try {
            externs = CommandLineRunner.getDefaultExterns();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        ArrayList<SourceFile> jsInputs = new ArrayList<SourceFile>();
        for (File f : inputs) {
            jsInputs.add(SourceFile.fromFile((File)f));
        }
        CompilerOptions options = new CompilerOptions();
        CompilationLevel.ADVANCED_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        WarningLevel.VERBOSE.setOptionsForWarningLevel(options);
        for (DiagnosticGroup dg : diagnosticGroups) {
            options.setWarningLevel(dg, CheckLevel.ERROR);
        }
        options.setCodingConvention((CodingConvention)new GoogleCodingConvention());
        Compiler compiler = new Compiler();
        MessageFormatter formatter = options.errorFormat.toFormatter((SourceExcerptProvider)compiler, false);
        AntErrorManager errorManager = new AntErrorManager(formatter, task);
        compiler.setErrorManager((ErrorManager)errorManager);
        Result r = compiler.compile(externs, jsInputs, options);
        if (!r.success) {
            return null;
        }
        String wrapped = "(function(){" + compiler.toSource() + "})();\n";
        return wrapped;
    }
}

