/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.wai;

import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.i18n.impl.AddTranslationPlugin;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalArtifactsService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalPlugin;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WaiportalTranslationsUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)WaiportalTranslationsUpgradePlugin.class.getName());

    public WaiportalTranslationsUpgradePlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        block6: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
            }
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            LivePortalManagerService livePortalManagerService = (LivePortalManagerService)WCMCoreUtils.getService(LivePortalManagerService.class);
            try {
                List livePortals = livePortalManagerService.getLivePortals(sessionProvider);
                HashMap artifactPlugins = ((CreatePortalArtifactsService)WCMCoreUtils.getService(CreatePortalArtifactsService.class)).getArtifactPlugins();
                for (CreatePortalPlugin plugin : artifactPlugins.values()) {
                    if (!(plugin instanceof AddTranslationPlugin) || !plugin.getName().equals("template-Upgrade-WAIPortal-translation")) continue;
                    for (Node node : livePortals) {
                        plugin.deployToPortal(sessionProvider, node.getName());
                    }
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Finish " + ((Object)((Object)this)).getClass().getName() + "............."));
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)"An unexpected error occurs when upgrade WAI portal translations", (Throwable)e);
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

