/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.util.TimeSource;

public class SoftExpiringCache<K, V> {
    private final Cache<K, V> cache;
    private final ConcurrentMap<V, Long> expirationTimes;
    private TimeSource timeSource;

    public SoftExpiringCache(Cache<K, V> cache) {
        this.cache = cache;
        this.expirationTimes = new MapMaker().weakKeys().makeMap();
        this.timeSource = new TimeSource();
    }

    public CachedObject<V> getElement(K key) {
        V value = this.cache.getElement(key);
        if (value == null) {
            return null;
        }
        Long expiration = (Long)this.expirationTimes.get(value);
        if (expiration == null) {
            return null;
        }
        return new CachedObject<V>(value, expiration < this.timeSource.currentTimeMillis());
    }

    public void addElement(K key, V value, long maxAge) {
        long now = this.timeSource.currentTimeMillis();
        this.cache.addElement(key, value);
        this.expirationTimes.put((Long)value, now + maxAge);
    }

    public void setTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
    }

    public static class CachedObject<V> {
        public final V obj;
        public final boolean isExpired;

        protected CachedObject(V obj, boolean isExpired) {
            this.obj = obj;
            this.isExpired = isExpired;
        }
    }
}

