/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.formula.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.formula.ImageData;
import org.xwiki.formula.ImageStorage;

@Component
@Singleton
public class CacheImageStorage
implements ImageStorage,
Initializable {
    @Inject
    private CacheManager cacheManager;
    private Cache<ImageData> cache;

    @Override
    public ImageData get(String id) {
        return (ImageData)this.cache.get(id);
    }

    @Override
    public void put(String id, ImageData data) {
        this.cache.set(id, (Object)data);
    }

    public void initialize() throws InitializationException {
        CacheConfiguration configuration = new CacheConfiguration();
        configuration.setConfigurationId("xwiki.plugin.formula");
        try {
            this.cache = this.cacheManager.createNewCache(configuration);
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to create cache", (Throwable)e);
        }
    }
}

