/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class GrowingOutputStream
extends OutputStream {
    private final OutputStream out;
    private ByteArrayOutputStream buffer;
    private boolean open;

    public GrowingOutputStream(OutputStream out, int initialBufferSize) {
        if (out == null) {
            throw new NullPointerException("No null output stream");
        }
        if (initialBufferSize < 0) {
            throw new IllegalArgumentException("No initial buffer size under 0");
        }
        this.out = out;
        this.buffer = new ByteArrayOutputStream(initialBufferSize);
        this.open = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.open) {
            throw new IOException("closed");
        }
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.open) {
            throw new IOException("closed");
        }
        this.buffer.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (!this.open) {
            throw new IOException("closed");
        }
        this.out.write(this.buffer.toByteArray());
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            throw new IOException("closed");
        }
        this.out.write(this.buffer.toByteArray());
        this.open = false;
        this.out.close();
    }
}

