/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.chromattic.entity;

import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.social.core.chromattic.entity.ActivityRefListEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityRefMonthEntity;
import org.exoplatform.social.core.chromattic.entity.IndexNumber;
import org.exoplatform.social.core.chromattic.entity.NamedEntity;

@PrimaryType(name="soc:activityrefyear", orderable=true)
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="soc")
public abstract class ActivityRefYearEntity
implements NamedEntity,
IndexNumber {
    private List<String> MONTH_NAME = Arrays.asList(new DateFormatSymbols(Locale.ENGLISH).getMonths());

    @Path
    public abstract String getPath();

    @Override
    @Name
    public abstract String getName();

    @Id
    public abstract String getId();

    @Override
    @Property(name="soc:number")
    @DefaultValue(value={"0"})
    public abstract Integer getNumber();

    public abstract void setNumber(Integer var1);

    @OneToMany
    public abstract Map<String, ActivityRefMonthEntity> getMonths();

    @OneToMany
    public abstract List<ActivityRefMonthEntity> getMonthsList();

    @ManyToOne
    public abstract ActivityRefListEntity getList();

    @Create
    public abstract ActivityRefMonthEntity newMonth();

    @Create
    public abstract ActivityRefMonthEntity newMonth(String var1);

    public void inc() {
        this.getList().inc();
        this.setNumber(this.getNumber() + 1);
    }

    public void desc() {
        this.getList().desc();
        this.setNumber(this.getNumber() - 1);
    }

    public ActivityRefMonthEntity getMonth(String month) {
        ActivityRefMonthEntity monthEntity = this.getMonths().get(month);
        if (monthEntity == null) {
            monthEntity = this.newMonth();
            this.getMonths().put(month, monthEntity);
            long longMonth = this.MONTH_NAME.indexOf(month);
            for (int i = this.getMonthsList().size() - 1; i >= 0; --i) {
                long longCurrent = this.MONTH_NAME.indexOf(this.getMonthsList().get(i).getName());
                if (longCurrent >= longMonth) continue;
                this.getMonthsList().add(i, monthEntity);
            }
        }
        return monthEntity;
    }

    public ActivityRefMonthEntity getMonth(String month, AtomicBoolean newYearMonthday) {
        ActivityRefMonthEntity monthEntity = this.getMonths().get(month);
        if (monthEntity == null) {
            monthEntity = this.newMonth();
            this.getMonths().put(month, monthEntity);
            long longMonth = this.MONTH_NAME.indexOf(month);
            for (int i = this.getMonthsList().size() - 1; i >= 0; --i) {
                long longCurrent = this.MONTH_NAME.indexOf(this.getMonthsList().get(i).getName());
                if (longCurrent >= longMonth) continue;
                this.getMonthsList().add(i, monthEntity);
            }
            newYearMonthday.set(true);
        }
        return monthEntity;
    }
}

