/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.model;

import java.io.InputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class Attachment {
    private static final Log LOG = ExoLogger.getLogger(Attachment.class);
    private String id;
    private String fileName;
    private String mimeType;
    private String workspace;
    private byte[] imageBytes;
    private long lastModified;

    public Attachment() {
    }

    public Attachment(String id, String fileName, String mimeType, InputStream inputStream, String workspace, long lastModified) throws Exception {
        this.id = id;
        this.fileName = fileName;
        this.setInputStream(inputStream);
        this.mimeType = mimeType;
        this.workspace = workspace;
        this.lastModified = lastModified;
    }

    public abstract String getAttachmentType();

    public String getDataPath(PortalContainer portalContainer) throws Exception {
        return this.getDataPath();
    }

    public String getDataPath() throws Exception {
        try {
            return this.getSession().getItem(this.getId()).getPath();
        }
        catch (ItemNotFoundException e) {
            LOG.warn((Object)"Failed to get data path", (Throwable)e);
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String s) {
        this.id = s;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String ws) {
        this.workspace = ws;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String s) {
        this.fileName = s;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String s) {
        this.mimeType = s;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getSize() {
        int length = this.imageBytes.length;
        int KB_SIZE = 1024;
        int MB_SIZE = 1024 * KB_SIZE;
        if (length >= MB_SIZE) {
            double size = length / MB_SIZE;
            return size + " MB";
        }
        if (length >= KB_SIZE) {
            double size = length / KB_SIZE;
            return size + " KB";
        }
        return length + " Bytes";
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public void setInputStream(InputStream input) throws Exception {
        if (input != null) {
            this.imageBytes = new byte[input.available()];
            input.read(this.imageBytes);
        } else {
            this.imageBytes = null;
        }
    }

    private Session getSession() throws Exception {
        return CommonsUtils.getSystemSessionProvider().getSession(this.workspace, CommonsUtils.getRepository());
    }
}

