/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.social.core.space.impl.SpaceServiceImpl;
import org.exoplatform.social.core.space.spi.SpaceService;

@Managed
@ManagedDescription(value="Social Service manager bean")
@NameTemplate(value={@Property(key="service", value="social"), @Property(key="view", value="SpaceService")})
@RESTEndpoint(path="spaceservice")
public class SpaceServiceManagerBean {
    SpaceService spaceService;

    public SpaceServiceManagerBean(SpaceServiceImpl spaceServiceImpl) {
        this.spaceService = spaceServiceImpl;
    }

    @Managed
    @ManagedDescription(value="Get Spaces super administrators")
    @Impact(value=ImpactType.READ)
    public List<String> getSpaceManager() {
        return this.spaceService.getSuperManagersMemberships().stream().map(membership -> membership.getMembershipType() + ":" + membership.getGroup()).collect(Collectors.toList());
    }

    @Managed
    @ManagedDescription(value="Add Spaces super managers membership")
    @Impact(value=ImpactType.WRITE)
    public void addSpaceManager(@ManagedDescription(value="Spaces super manger role") @ManagedName(value="permissionExpression") String permissionExpression) {
        this.spaceService.addSuperManagersMembership(permissionExpression);
    }

    @Managed
    @ManagedDescription(value="Remove Spaces super managers membership")
    @Impact(value=ImpactType.WRITE)
    public void removeSpaceManager(@ManagedDescription(value="Spaces super manger memberships") @ManagedName(value="permissionExpression") String permissionExpression) {
        this.spaceService.removeSuperManagersMembership(permissionExpression);
    }
}

