/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.key;

import org.exoplatform.social.core.identity.model.ActiveIdentityFilter;
import org.exoplatform.social.core.storage.cache.model.key.ScopeCacheKey;

public class ActiveIdentityKey
extends ScopeCacheKey {
    private static final long serialVersionUID = -1731263881104519519L;
    private final int days;
    private final String userGroup;

    public ActiveIdentityKey(int days) {
        this.days = days;
        this.userGroup = null;
    }

    public ActiveIdentityKey(ActiveIdentityFilter filter) {
        this.days = filter.getDays();
        this.userGroup = filter.getUserGroups();
    }

    public ActiveIdentityKey(String userGroup) {
        this.days = 0;
        this.userGroup = userGroup;
    }

    public ActiveIdentityKey(int days, String userGroup) {
        this.days = days;
        this.userGroup = userGroup;
    }

    public int getDays() {
        return this.days;
    }

    public String getUserGroup() {
        return this.userGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActiveIdentityKey)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActiveIdentityKey that = (ActiveIdentityKey)o;
        if (this.days != that.days) {
            return false;
        }
        return !(this.userGroup != null ? !this.userGroup.equals(that.userGroup) : that.userGroup != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.days;
        result = 31 * result + (this.userGroup != null ? this.userGroup.hashCode() : 0);
        return result;
    }
}

