/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.exoplatform.web.controller.router.PercentEncoding;
import org.gatein.common.io.UndeclaredIOException;

class Path {
    public static final Path SLASH = Path.parse("/");
    private final Data data;
    private final int offset;
    private final String value;

    static Path parse(String path) {
        try {
            Data data = new Data(path);
            return new Path(data, 0);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    private Path(Data data, int offset) {
        this.data = data;
        this.offset = offset;
        this.value = data.value.substring(offset);
    }

    String getValue() {
        return this.value;
    }

    int getRawStart(int index) {
        return this.data.getRawStart(this.innerIndex(index)) - this.data.getRawStart(this.offset);
    }

    int getRawEnd(int index) {
        return this.data.getRawEnd(this.innerIndex(index)) - this.data.getRawStart(this.offset);
    }

    int getRawLength(int index) {
        return this.getRawEnd(index) - this.getRawStart(index);
    }

    char charAt(int pos) {
        return this.value.charAt(pos);
    }

    int length() {
        return this.value.length();
    }

    int indexOf(int c, int index) {
        return this.value.indexOf(c, index);
    }

    Path subPath(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("No negative index accepted");
        }
        if (index == 0) {
            return this;
        }
        int i = this.offset + index;
        if (i >= this.data.value.length()) {
            throw new IndexOutOfBoundsException("Index can't be greater than length");
        }
        return new Path(this.data, i);
    }

    private int innerIndex(int outterIndex) throws IndexOutOfBoundsException {
        if (outterIndex < 0) {
            throw new IndexOutOfBoundsException("No negative index accepted");
        }
        int pos = this.offset + outterIndex;
        if (pos > this.data.value.length()) {
            throw new IndexOutOfBoundsException("Index can't be greater than length");
        }
        return pos;
    }

    private static final class Data {
        private final String rawValue;
        private final String value;
        private final int[] mapping;

        private int hex(char c) {
            if (c >= '0' && c <= '9') {
                return c - 48;
            }
            if (c >= 'A' && c <= 'F') {
                return c + 10 - 65;
            }
            if (c >= 'a' && c <= 'f') {
                return c + 10 - 97;
            }
            throw new IllegalArgumentException("Invalid hex code in " + this.rawValue);
        }

        private Data(String rawValue) throws IOException, IllegalArgumentException {
            this.rawValue = rawValue;
            int len = rawValue.length();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int[] mapping = new int[len];
            int count = 0;
            int i = 0;
            while (i < len) {
                char c = rawValue.charAt(i);
                mapping[count++] = i++;
                if (PercentEncoding.PATH_SEGMENT.accept(c)) {
                    baos.write(c);
                    continue;
                }
                if (c == '%') {
                    if (i + 2 >= len) {
                        throw new IllegalArgumentException("Invalid percent escape in " + rawValue);
                    }
                    int h = (this.hex(rawValue.charAt(i + 1)) << 4) + this.hex(rawValue.charAt(i + 2));
                    baos.write(h);
                    i += 3;
                    int size = 0;
                    int j = h;
                    while ((j & 0x80) != 0) {
                        ++size;
                        j <<= 1;
                    }
                    if (size == 0) {
                        size = 1;
                    } else if (size > 6) {
                        throw new IllegalArgumentException("Invalid percent escape in " + rawValue);
                    }
                    int to = i + (size - 1) * 3;
                    if (to > len) {
                        throw new IllegalArgumentException("Invalid percent escape in " + rawValue);
                    }
                    while (i < to) {
                        if (rawValue.charAt(i) != '%') {
                            throw new IllegalArgumentException("Invalid percent escape in " + rawValue);
                        }
                        h = (this.hex(rawValue.charAt(i + 1)) << 4) + this.hex(rawValue.charAt(i + 2));
                        baos.write(h);
                        i += 3;
                    }
                    continue;
                }
                if (c == '/') {
                    baos.write(47);
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException("Unsupported char value in path " + c + " / " + c);
            }
            this.value = baos.toString("UTF-8");
            this.mapping = mapping;
        }

        int getRawStart(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("No negative index accepted");
            }
            if (index >= this.value.length()) {
                throw new IndexOutOfBoundsException("Index can't be greater than length");
            }
            return this.mapping[index];
        }

        int getRawEnd(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("No negative index accepted");
            }
            if (index >= this.value.length()) {
                throw new IndexOutOfBoundsException("Index can't be greater than length");
            }
            if (++index == this.value.length()) {
                return this.rawValue.length();
            }
            return this.mapping[index];
        }
    }
}

