/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.HashLockedDomainService;
import org.apache.shindig.gadgets.LockedDomainService;

public abstract class AbstractLockedDomainService
implements LockedDomainService {
    protected static final String LOCKED_DOMAIN_REQUIRED_KEY = "gadgets.uri.iframe.lockedDomainRequired";
    protected static final String PERMITTED_REFERER_DOMAINS_KEY = "shindig.locked-domain.permittedRefererDomains";
    protected static final String LOCKED_DOMAIN_FEATURE = "locked-domain";
    private final boolean enabled;
    private boolean refererCheckEnabled;
    protected final Map<String, Boolean> required;
    private boolean lockSecurityTokens = false;
    private LockedDomainObserver ldObserver;
    protected final Map<String, List<Object>> permittedRefererDomains;
    private static final String classname = HashLockedDomainService.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");

    protected AbstractLockedDomainService(ContainerConfig config, boolean enabled) {
        this.enabled = enabled;
        this.required = Maps.newHashMap();
        this.permittedRefererDomains = Maps.newHashMap();
        if (enabled) {
            this.ldObserver = new LockedDomainObserver();
            config.addConfigObserver((ContainerConfig.ConfigObserver)this.ldObserver, true);
        }
    }

    @Inject
    public void setRefererCheckEnabled(@Named(value="shindig.locked-domain.refererCheck.enabled") boolean refererCheckEnabled) {
        this.refererCheckEnabled = refererCheckEnabled;
    }

    @Override
    public abstract String getLockedDomainForGadget(Gadget var1, String var2) throws GadgetException;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public abstract boolean isGadgetValidForHost(String var1, Gadget var2, String var3);

    @Override
    public abstract boolean isHostUsingLockedDomain(String var1);

    @Override
    public boolean isSafeForOpenProxy(String host) {
        if (this.isEnabled()) {
            return !this.isHostUsingLockedDomain(host);
        }
        return true;
    }

    @Override
    public boolean isRefererCheckEnabled() {
        return this.refererCheckEnabled;
    }

    @Inject(optional=true)
    public void setLockSecurityTokens(@Named(value="shindig.locked-domain.lock-security-tokens") Boolean lockSecurityTokens) {
        this.lockSecurityTokens = lockSecurityTokens;
    }

    protected boolean isDomainLockingEnforced(String container) {
        return this.required.get(container);
    }

    protected boolean isExcludedFromLockedDomain(Gadget gadget, String container) {
        return false;
    }

    protected boolean isGadgetReqestingLocking(Gadget gadget) {
        if (this.lockSecurityTokens) {
            return gadget.getAllFeatures().contains(LOCKED_DOMAIN_FEATURE);
        }
        return gadget.getViewFeatures().keySet().contains(LOCKED_DOMAIN_FEATURE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidReferer(Gadget gadget, String container) {
        String referer = gadget.getContext().getReferer();
        List<Object> domainList = this.permittedRefererDomains.get(container);
        if (null != referer && !"".equals(referer.trim())) {
            try {
                URL url = new URL(referer);
                if (domainList.isEmpty()) return true;
                boolean matched = false;
                String refererHost = url.getHost().toLowerCase();
                for (Object permittedDomain : domainList) {
                    if (!refererHost.endsWith(((String)permittedDomain).toLowerCase())) continue;
                    return true;
                }
                if (matched) return true;
                LOG.logp(Level.SEVERE, classname, "Referer check failed.", "failedToValidate", new Object[]{referer});
                return false;
            }
            catch (MalformedURLException e) {
                LOG.logp(Level.SEVERE, classname, "Referer check failed, malformed referer url.", "failedToValidate", new Object[]{referer});
                return false;
            }
        }
        if (domainList.isEmpty()) return true;
        LOG.logp(Level.SEVERE, classname, "Referer check failed, referer url is not valid.", "failedToValidate", new Object[]{referer});
        return false;
    }

    private class LockedDomainObserver
    implements ContainerConfig.ConfigObserver {
        private LockedDomainObserver() {
        }

        public void containersChanged(ContainerConfig config, Collection<String> changed, Collection<String> removed) {
            for (String container : changed) {
                AbstractLockedDomainService.this.required.put(container, config.getBool(container, AbstractLockedDomainService.LOCKED_DOMAIN_REQUIRED_KEY));
                AbstractLockedDomainService.this.permittedRefererDomains.put(container, config.getList(container, AbstractLockedDomainService.PERMITTED_REFERER_DOMAINS_KEY));
            }
            for (String container : removed) {
                AbstractLockedDomainService.this.required.remove(container);
                AbstractLockedDomainService.this.permittedRefererDomains.remove(container);
            }
        }
    }
}

