/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

public class GadgetException
extends Exception {
    private final Code code;
    private final int httpStatusCode;

    public GadgetException(Code code, int httpStatusCode) {
        this.code = code;
        this.httpStatusCode = httpStatusCode;
    }

    public GadgetException(Code code, Throwable cause, int httpStatusCode) {
        super(cause);
        this.code = code;
        this.httpStatusCode = httpStatusCode;
    }

    public GadgetException(Code code, String msg, Throwable cause, int httpStatusCode) {
        super(msg, cause);
        this.code = code;
        this.httpStatusCode = httpStatusCode;
    }

    public GadgetException(Code code, String msg, int httpStatusCode) {
        super(msg);
        this.code = code;
        this.httpStatusCode = httpStatusCode;
    }

    public GadgetException(Code code) {
        this(code, 500);
    }

    public GadgetException(Code code, Throwable cause) {
        this(code, cause, 500);
    }

    public GadgetException(Code code, String msg, Throwable cause) {
        this(code, msg, cause, 500);
    }

    public GadgetException(Code code, String msg) {
        this(code, msg, 500);
    }

    public Code getCode() {
        return this.code;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public static enum Code {
        INTERNAL_SERVER_ERROR,
        INVALID_PATH,
        INVALID_CONFIG,
        INVALID_USER_DATA,
        INVALID_SECURITY_TOKEN,
        EMPTY_XML_DOCUMENT,
        MALFORMED_XML_DOCUMENT,
        FAILED_TO_RETRIEVE_CONTENT,
        UNSUPPORTED_FEATURE,
        INVALID_PARAMETER,
        MISSING_PARAMETER,
        UNRECOGNIZED_PARAMETER,
        POST_TOO_LARGE,
        MISSING_FEATURE_REGISTRY,
        MISSING_MESSAGE_BUNDLE_CACHE,
        MISSING_REMOTE_OBJECT_FETCHER,
        MISSING_SPEC_CACHE,
        MALFORMED_FOR_SAFE_INLINING,
        CSS_PARSE_ERROR,
        HTML_PARSE_ERROR,
        IMAGE_PARSE_ERROR,
        JS_PARSE_ERROR,
        UNKNOWN_VIEW_SPECIFIED,
        NON_WHITELISTED_GADGET,
        OAUTH_STORAGE_ERROR,
        OAUTH_APPROVAL_NEEDED,
        REQUEST_SIGNING_FAILURE,
        JS_PROCESSING_ERROR,
        GADGET_HOST_MISMATCH,
        GADGET_ADMIN_STORAGE_ERROR,
        GADGET_ADMIN_FEATURE_NOT_ALLOWED;

    }
}

