/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.config.ConfigContributor;
import org.apache.shindig.gadgets.config.ConfigProcessor;

public class DefaultConfigProcessor
implements ConfigProcessor {
    @VisibleForTesting
    static final String GADGETS_FEATURES_KEY = "gadgets.features";
    private final Map<String, ConfigContributor> featureContributors;
    private final List<ConfigContributor> globalContributors;
    private final ContainerConfig containerConfig;

    @Inject
    public DefaultConfigProcessor(Map<String, ConfigContributor> featureContributors, ContainerConfig containerConfig) {
        this.featureContributors = featureContributors;
        this.globalContributors = Lists.newLinkedList();
        this.containerConfig = containerConfig;
    }

    @Inject(optional=true)
    public void setGlobalContributors(List<ConfigContributor> globalContribs) {
        this.globalContributors.addAll(globalContribs);
    }

    @Override
    public Map<String, Object> getConfig(String container, List<String> features, String host, Gadget gadget) {
        HashMap config = Maps.newHashMap();
        for (ConfigContributor contrib : this.globalContributors) {
            this.contribute(contrib, config, container, host, gadget);
        }
        Map featureConfig = this.containerConfig.getMap(container, GADGETS_FEATURES_KEY);
        if (featureConfig != null) {
            for (String name : features) {
                Object conf = featureConfig.get(name);
                if (conf != null) {
                    config.put(name, conf);
                }
                this.contribute(this.featureContributors.get(name), config, container, host, gadget);
            }
        }
        return config;
    }

    private void contribute(ConfigContributor contrib, Map<String, Object> config, String container, String host, Gadget gadget) {
        if (contrib != null) {
            if (host != null) {
                contrib.contribute(config, container, host);
            } else if (gadget != null) {
                contrib.contribute(config, gadget);
            }
        }
    }
}

