/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.JsCompileMode;
import org.apache.shindig.gadgets.features.ApiDirective;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureRegistryProvider;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.js.JsContent;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.uri.JsUriManager;

public abstract class BaseSurfaceJsProcessor
implements JsProcessor {
    protected final FeatureRegistryProvider featureRegistryProvider;
    protected final Provider<GadgetContext> context;

    protected BaseSurfaceJsProcessor(FeatureRegistryProvider featureRegistryProvider, Provider<GadgetContext> context) {
        this.featureRegistryProvider = featureRegistryProvider;
        this.context = context;
    }

    protected final FeatureRegistry getFeatureRegistry(JsUriManager.JsUri jsUri) throws JsException {
        try {
            return this.featureRegistryProvider.get(jsUri.getRepository());
        }
        catch (GadgetException e) {
            throw new JsException(e.getHttpStatusCode(), e.getMessage());
        }
    }

    protected final List<String> getExports(FeatureRegistry.FeatureBundle bundle, JsUriManager.JsUri jsUri) {
        if (jsUri.getCompileMode() == JsCompileMode.CONCAT_COMPILE_EXPORT_ALL) {
            return bundle.getApis(ApiDirective.Type.JS, true);
        }
        if (jsUri.getCompileMode() == JsCompileMode.CONCAT_COMPILE_EXPORT_EXPLICIT && jsUri.getLibs().contains(bundle.getName())) {
            return bundle.getApis(ApiDirective.Type.JS, true);
        }
        return Lists.newArrayList();
    }

    protected final List<JsContent> getSurfaceJsContents(FeatureRegistry featureRegistry, String featureName) {
        ImmutableList.Builder result = ImmutableList.builder();
        FeatureRegistry.LookupResult lookup = featureRegistry.getFeatureResources((GadgetContext)this.context.get(), (Collection<String>)ImmutableList.of((Object)featureName), null);
        for (FeatureRegistry.FeatureBundle bundle : lookup.getBundles()) {
            for (FeatureResource resource : bundle.getResources()) {
                result.add((Object)JsContent.fromFeature(resource.getDebugContent(), resource.getName(), bundle, resource));
            }
        }
        return result.build();
    }

    protected Collection<Input> generateInputs(List<String> symbols) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (String symbol : symbols) {
            String ns = this.getNamespace(symbol);
            Input input = (Input)result.get(ns);
            if (input == null) {
                input = ns != null ? Input.newLocal(ns, this.expandNamespace(ns)) : Input.newGlobal();
                result.put(ns, input);
            }
            String property = ns != null ? this.getProperty(symbol) : symbol;
            input.properties.add(property);
        }
        return result.values();
    }

    private List<String> expandNamespace(String namespace) {
        int idx;
        ArrayList result = Lists.newArrayList();
        int from = 0;
        while ((idx = namespace.indexOf(46, from)) >= 0) {
            result.add(namespace.substring(0, idx));
            from = idx + 1;
        }
        result.add(namespace);
        return result;
    }

    private String getNamespace(String symbol) {
        int idx = symbol.lastIndexOf(46);
        return idx >= 0 ? symbol.substring(0, idx) : null;
    }

    private String getProperty(String symbol) {
        int idx = symbol.lastIndexOf(46);
        return idx >= 0 ? symbol.substring(idx + 1) : symbol;
    }

    protected static class Input {
        String namespace;
        List<String> components;
        List<String> properties;

        private Input(String namespace, List<String> components) {
            this.namespace = namespace;
            this.components = components;
            this.properties = Lists.newArrayList();
        }

        static Input newGlobal() {
            return new Input(null, (List<String>)ImmutableList.of());
        }

        static Input newLocal(String namespace, List<String> components) {
            return new Input(namespace, components);
        }
    }
}

