/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.uri.UriStatus;

public class IfModifiedSinceProcessor
implements JsProcessor {
    public static final int DEFAULT_VERSIONED_MAXAGE = -1;
    private int versionedMaxAge = -1;

    @Inject(optional=true)
    public void setVersionedMaxAge(@Named(value="shindig.jscontent.versioned.maxage") Integer maxAge) {
        if (maxAge != null) {
            this.versionedMaxAge = maxAge;
        }
    }

    @Override
    public boolean process(JsRequest request, JsResponseBuilder builder) {
        if (request.isInCache() && request.getJsUri().getStatus() == UriStatus.VALID_VERSIONED) {
            builder.setStatusCode(304);
            builder.setCacheTtlSecs(this.versionedMaxAge);
            return false;
        }
        return true;
    }
}

