/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.common.util.TimeSource;

public class OAuthClientState
extends AbstractSecurityToken {
    private static final EnumSet<AbstractSecurityToken.Keys> MAP_KEYS = EnumSet.of(AbstractSecurityToken.Keys.EXPIRES, AbstractSecurityToken.Keys.OWNER);
    private static final String REQ_TOKEN_KEY = "r";
    private static final String REQ_TOKEN_SECRET_KEY = "rs";
    private static final String ACCESS_TOKEN_KEY = "a";
    private static final String ACCESS_TOKEN_SECRET_KEY = "as";
    private static final String SESSION_HANDLE_KEY = "sh";
    private static final String ACCESS_TOKEN_EXPIRATION_KEY = "e";
    private final Map<String, String> state;
    private final BlobCrypter crypter;

    public OAuthClientState(BlobCrypter crypter) {
        this.state = Maps.newHashMap();
        this.crypter = crypter;
    }

    public OAuthClientState(BlobCrypter crypter, String stateBlob) {
        this.crypter = crypter;
        Map state = null;
        if (stateBlob != null) {
            try {
                state = crypter.unwrap(stateBlob);
                if (state == null) {
                    state = Maps.newHashMap();
                }
                this.loadFromMap(state);
                state.remove(AbstractSecurityToken.Keys.EXPIRES.getKey());
                state.remove(AbstractSecurityToken.Keys.OWNER.getKey());
                this.enforceNotExpired();
            }
            catch (BlobCrypterException e) {
                state = null;
            }
        }
        if (state == null) {
            state = Maps.newHashMap();
            this.setOwner(null);
            this.setExpiresAt(null);
        }
        this.state = state;
    }

    public boolean isEmpty() {
        return this.state.isEmpty() && this.getOwnerId() == null;
    }

    public String getEncryptedState() throws BlobCrypterException {
        this.setExpires();
        Map map = this.toMap();
        map.putAll(this.state);
        return this.crypter.wrap(map);
    }

    public String getRequestToken() {
        return this.state.get(REQ_TOKEN_KEY);
    }

    public void setRequestToken(String requestToken) {
        this.setNullCheck(REQ_TOKEN_KEY, requestToken);
    }

    public String getRequestTokenSecret() {
        return this.state.get(REQ_TOKEN_SECRET_KEY);
    }

    public void setRequestTokenSecret(String requestTokenSecret) {
        this.setNullCheck(REQ_TOKEN_SECRET_KEY, requestTokenSecret);
    }

    public String getAccessToken() {
        return this.state.get(ACCESS_TOKEN_KEY);
    }

    public void setAccessToken(String accessToken) {
        this.setNullCheck(ACCESS_TOKEN_KEY, accessToken);
    }

    public String getAccessTokenSecret() {
        return this.state.get(ACCESS_TOKEN_SECRET_KEY);
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.setNullCheck(ACCESS_TOKEN_SECRET_KEY, accessTokenSecret);
    }

    public String getSessionHandle() {
        return this.state.get(SESSION_HANDLE_KEY);
    }

    public void setSessionHandle(String sessionHandle) {
        this.setNullCheck(SESSION_HANDLE_KEY, sessionHandle);
    }

    public long getTokenExpireMillis() {
        String expiration = this.state.get(ACCESS_TOKEN_EXPIRATION_KEY);
        if (expiration == null) {
            return 0L;
        }
        return Long.parseLong(expiration);
    }

    public void setTokenExpireMillis(long expirationMillis) {
        this.setNullCheck(ACCESS_TOKEN_EXPIRATION_KEY, Long.toString(expirationMillis));
    }

    public String getOwner() {
        return this.getOwnerId();
    }

    public void setOwner(String owner) {
        this.setOwnerId(owner);
    }

    private void setNullCheck(String key, String value) {
        if (value == null) {
            this.state.remove(key);
        } else {
            this.state.put(key, value);
        }
    }

    public String getUpdatedToken() {
        throw new UnsupportedOperationException();
    }

    public String getAuthenticationMode() {
        throw new UnsupportedOperationException();
    }

    public boolean isAnonymous() {
        throw new UnsupportedOperationException();
    }

    protected EnumSet<AbstractSecurityToken.Keys> getMapKeys() {
        return MAP_KEYS;
    }

    @VisibleForTesting
    protected AbstractSecurityToken setTimeSource(TimeSource timeSource) {
        return super.setTimeSource(timeSource);
    }
}

