/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;

public class OAuth2Arguments {
    private static final String BYPASS_SPEC_CACHE_PARAM = "bypassSpecCache";
    private static final String SCOPE_PARAM = "OAUTH_SCOPE";
    private static final String SERVICE_PARAM = "OAUTH_SERVICE_NAME";
    private final boolean bypassSpecCache;
    private final Map<String, String> requestOptions = Maps.newTreeMap();
    private final String scope;
    private final String serviceName;

    public OAuth2Arguments(AuthType auth, Map<String, String> map) {
        if (AuthType.OAUTH2.equals((Object)auth)) {
            this.requestOptions.putAll(map);
            this.serviceName = OAuth2Arguments.getAuthInfoParam(this.requestOptions, SERVICE_PARAM, "");
            this.scope = OAuth2Arguments.getAuthInfoParam(this.requestOptions, SCOPE_PARAM, "");
            this.bypassSpecCache = "1".equals(OAuth2Arguments.getAuthInfoParam(this.requestOptions, BYPASS_SPEC_CACHE_PARAM, null));
        } else {
            this.serviceName = null;
            this.scope = null;
            this.bypassSpecCache = false;
        }
    }

    public OAuth2Arguments(HttpServletRequest request) throws GadgetException {
        this.serviceName = OAuth2Arguments.getRequestParam(request, SERVICE_PARAM, "");
        this.scope = OAuth2Arguments.getRequestParam(request, SCOPE_PARAM, "");
        this.bypassSpecCache = "1".equals(OAuth2Arguments.getRequestParam(request, BYPASS_SPEC_CACHE_PARAM, null));
        Enumeration<String> params = OAuth2Arguments.getParameterNames(request);
        while (params.hasMoreElements()) {
            String name = params.nextElement();
            this.requestOptions.put(name, request.getParameter(name));
        }
    }

    public OAuth2Arguments(OAuth2Arguments orig) {
        this.serviceName = orig.serviceName;
        this.scope = orig.scope;
        this.bypassSpecCache = orig.bypassSpecCache;
        this.requestOptions.putAll(orig.requestOptions);
    }

    public OAuth2Arguments(RequestAuthenticationInfo info) {
        this(info.getAuthType(), info.getAttributes());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OAuth2Arguments)) {
            return false;
        }
        OAuth2Arguments other = (OAuth2Arguments)obj;
        return this.bypassSpecCache == other.getBypassSpecCache() && this.serviceName.equals(other.getServiceName());
    }

    public boolean getBypassSpecCache() {
        return this.bypassSpecCache;
    }

    private static Enumeration<String> getParameterNames(HttpServletRequest request) {
        return request.getParameterNames();
    }

    public String getRequestOption(String name) {
        return this.requestOptions.get(name);
    }

    public String getRequestOption(String name, String def) {
        String val = this.requestOptions.get(name);
        return val != null ? val : def;
    }

    public String getScope() {
        return this.scope;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.bypassSpecCache, this.serviceName});
    }

    private static String getAuthInfoParam(Map<String, String> attrs, String name, @Nullable String def) {
        String val = attrs.get(name);
        if (val == null) {
            val = def;
        }
        return val;
    }

    private static String getRequestParam(HttpServletRequest request, String name, String def) {
        String val = request.getParameter(name);
        if (val == null) {
            val = def;
        }
        return val;
    }
}

