/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.handler;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.List;
import org.apache.shindig.gadgets.oauth2.handler.AuthorizationEndpointResponseHandler;
import org.apache.shindig.gadgets.oauth2.handler.BasicAuthenticationHandler;
import org.apache.shindig.gadgets.oauth2.handler.BearerTokenHandler;
import org.apache.shindig.gadgets.oauth2.handler.ClientAuthenticationHandler;
import org.apache.shindig.gadgets.oauth2.handler.ClientCredentialsGrantTypeHandler;
import org.apache.shindig.gadgets.oauth2.handler.CodeAuthorizationResponseHandler;
import org.apache.shindig.gadgets.oauth2.handler.CodeGrantTypeHandler;
import org.apache.shindig.gadgets.oauth2.handler.GrantRequestHandler;
import org.apache.shindig.gadgets.oauth2.handler.MacTokenHandler;
import org.apache.shindig.gadgets.oauth2.handler.ResourceRequestHandler;
import org.apache.shindig.gadgets.oauth2.handler.StandardAuthenticationHandler;
import org.apache.shindig.gadgets.oauth2.handler.TokenAuthorizationResponseHandler;
import org.apache.shindig.gadgets.oauth2.handler.TokenEndpointResponseHandler;
import org.apache.shindig.gadgets.oauth2.logger.FilteredLogger;

public class OAuth2HandlerModule
extends AbstractModule {
    private static final FilteredLogger LOG = FilteredLogger.getFilteredLogger(OAuth2HandlerModule.class.getName());

    protected void configure() {
        if (LOG.isLoggable()) {
            LOG.entering(OAuth2HandlerModule.class.getName(), "configure");
        }
    }

    @Provides
    @Singleton
    public static List<AuthorizationEndpointResponseHandler> provideAuthorizationEndpointResponseHandlers(CodeAuthorizationResponseHandler codeAuthorizationResponseHandler) {
        return ImmutableList.of((Object)codeAuthorizationResponseHandler);
    }

    @Provides
    @Singleton
    public static List<ClientAuthenticationHandler> provideClientAuthenticationHandlers(BasicAuthenticationHandler basicAuthenticationHandler, StandardAuthenticationHandler standardAuthenticationHandler) {
        return ImmutableList.of((Object)basicAuthenticationHandler, (Object)standardAuthenticationHandler);
    }

    @Provides
    @Singleton
    public static List<GrantRequestHandler> provideGrantRequestHandlers(ClientCredentialsGrantTypeHandler clientCredentialsGrantTypeHandler, CodeGrantTypeHandler codeGrantTypeHandler) {
        return ImmutableList.of((Object)clientCredentialsGrantTypeHandler, (Object)codeGrantTypeHandler);
    }

    @Provides
    @Singleton
    public static List<TokenEndpointResponseHandler> provideTokenEndpointResponseHandlers(TokenAuthorizationResponseHandler tokenAuthorizationResponseHandler) {
        return ImmutableList.of((Object)tokenAuthorizationResponseHandler);
    }

    @Provides
    @Singleton
    public static List<ResourceRequestHandler> provideTokenHandlers(BearerTokenHandler bearerTokenHandler, MacTokenHandler macTokenHandler) {
        return ImmutableList.of((Object)bearerTokenHandler, (Object)macTokenHandler);
    }
}

