/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public final class CajaCssUtils {
    private CajaCssUtils() {
    }

    public static <T extends CssTree> List<T> children(CssTree node, Class<T> nodeType) {
        ArrayList result = Lists.newArrayList();
        for (CssTree child : node.children()) {
            if (!nodeType.isAssignableFrom(child.getClass())) continue;
            result.add(nodeType.cast(child));
        }
        return result;
    }

    public static <T extends CssTree> List<T> descendants(CssTree node, final Class<T> nodeType) {
        final ArrayList descendants = Lists.newArrayList();
        node.acceptPreOrder(new Visitor(){

            public boolean visit(AncestorChain<?> ancestorChain) {
                if (nodeType.isAssignableFrom(ancestorChain.node.getClass())) {
                    descendants.add(nodeType.cast(ancestorChain.node));
                }
                return true;
            }
        }, null);
        return descendants;
    }
}

