/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.process;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.admin.GadgetAdminStore;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureRegistryProvider;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.variables.VariableSubstituter;

@Singleton
public class Processor {
    private static final String classname = Processor.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final GadgetSpecFactory gadgetSpecFactory;
    private final VariableSubstituter substituter;
    private final ContainerConfig containerConfig;
    private final GadgetAdminStore gadgetAdminStore;
    private final FeatureRegistryProvider featureRegistryProvider;

    @Inject
    public Processor(GadgetSpecFactory gadgetSpecFactory, VariableSubstituter substituter, ContainerConfig containerConfig, GadgetAdminStore gadgetAdminStore, FeatureRegistryProvider featureRegistryProvider) {
        this.gadgetSpecFactory = gadgetSpecFactory;
        this.substituter = substituter;
        this.gadgetAdminStore = gadgetAdminStore;
        this.containerConfig = containerConfig;
        this.featureRegistryProvider = featureRegistryProvider;
    }

    protected void validateGadgetUrl(Uri url) throws ProcessingException {
        if (!"http".equalsIgnoreCase(url.getScheme()) && !"https".equalsIgnoreCase(url.getScheme())) {
            throw new ProcessingException("Unsupported scheme (must be http or https).", 403);
        }
    }

    public Gadget process(GadgetContext context) throws ProcessingException {
        FeatureRegistry featureRegistry;
        GadgetSpec spec;
        try {
            Uri url = this.gadgetSpecFactory.getGadgetUri(context);
            if (url == null) {
                throw new ProcessingException("Missing or malformed url parameter", 400);
            }
            this.validateGadgetUrl(url);
            if (!this.gadgetAdminStore.isWhitelisted(context.getContainer(), url.toString())) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.INFO, classname, "process", "renderNonWhitelistedGadget", new Object[]{url});
                }
                throw new ProcessingException("The requested gadget is not authorized for this container", 403);
            }
            spec = this.gadgetSpecFactory.getGadgetSpec(context);
            spec = this.substituter.substitute(context, spec);
            if (context.getSanitize()) {
                spec = spec.removeUrlViews();
            }
            featureRegistry = this.featureRegistryProvider.get(context.getRepository());
        }
        catch (GadgetException e) {
            throw new ProcessingException(e.getMessage(), e, e.getHttpStatusCode());
        }
        return new Gadget().setContext(context).setGadgetFeatureRegistry(featureRegistry).setSpec(spec).setCurrentView(this.getView(context, spec));
    }

    private View getView(GadgetContext context, GadgetSpec spec) {
        String viewName = context.getView();
        View view = spec.getView(viewName);
        if (view == null) {
            String container = context.getContainer();
            String property = "${Cur['gadgets.features'].views['" + viewName + "'].aliases}";
            for (Object alias : this.containerConfig.getList(container, property)) {
                viewName = alias.toString();
                view = spec.getView(viewName);
                if (view == null) continue;
                return view;
            }
        }
        if (view == null) {
            view = spec.getView("default");
        }
        return view;
    }
}

