/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.shindig.gadgets.render.RpcServiceLookup;
import org.apache.shindig.gadgets.render.ServiceFetcher;

@Singleton
public class DefaultRpcServiceLookup
implements RpcServiceLookup {
    private final Cache<String, Multimap<String, String>> containerServices;
    private final ServiceFetcher fetcher;

    @Inject
    public DefaultRpcServiceLookup(ServiceFetcher fetcher, @Named(value="org.apache.shindig.serviceExpirationDurationMinutes") Long duration) {
        this.containerServices = CacheBuilder.newBuilder().expireAfterWrite(duration * 60L, TimeUnit.SECONDS).build();
        this.fetcher = fetcher;
    }

    @Override
    public Multimap<String, String> getServicesFor(final String container, final String host) {
        if (container == null || container.length() == 0 || host == null) {
            return ImmutableMultimap.of();
        }
        try {
            return (Multimap)this.containerServices.get((Object)container, (Callable)new Callable<Multimap<String, String>>(){

                @Override
                public Multimap<String, String> call() {
                    return (Multimap)Objects.firstNonNull(DefaultRpcServiceLookup.this.fetcher.getServicesForContainer(container, host), (Object)ImmutableMultimap.of());
                }
            });
        }
        catch (ExecutionException e) {
            return ImmutableMultimap.of();
        }
    }

    void setServicesFor(String container, Multimap<String, String> foundServices) {
        this.containerServices.asMap().put(container, foundServices);
    }
}

