/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.render.ServiceFetcher;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DefaultServiceFetcher
implements ServiceFetcher {
    public static final String JSON_RESPONSE_WRAPPER_ELEMENT = "result";
    public static final String OSAPI_FEATURE_CONFIG = "osapi";
    public static final String OSAPI_SERVICES = "osapi.services";
    public static final String GADGETS_FEATURES_CONFIG = "gadgets.features";
    public static final String SYSTEM_LIST_METHODS_METHOD = "system.listMethods";
    public static final String OSAPI_BASE_ENDPOINTS = "endPoints";
    private static final String classname = DefaultServiceFetcher.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final ContainerConfig containerConfig;
    private final HttpFetcher fetcher;
    private Authority authority;
    private SecurityTokenCodec codec;

    @Inject
    public DefaultServiceFetcher(ContainerConfig config, HttpFetcher fetcher) {
        this.containerConfig = config;
        this.fetcher = fetcher;
    }

    @Inject(optional=true)
    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    @Inject
    public void setSecurityTokenCodec(SecurityTokenCodec codec) {
        this.codec = codec;
    }

    @Override
    public Multimap<String, String> getServicesForContainer(String container, String host) {
        if (this.containerConfig == null) {
            return ImmutableMultimap.builder().build();
        }
        LinkedHashMultimap endpointServices = LinkedHashMultimap.create();
        Map declaredServices = (Map)this.containerConfig.getMap(container, GADGETS_FEATURES_CONFIG).get(OSAPI_SERVICES);
        if (declaredServices != null) {
            for (Map.Entry entry : declaredServices.entrySet()) {
                Iterable entryValue = (Iterable)entry.getValue();
                endpointServices.putAll(entry.getKey(), entryValue);
            }
        }
        List<String> endpoints = this.getEndpointsFromContainerConfig(container, host);
        Iterator<String> i$ = endpoints.iterator();
        while (i$.hasNext()) {
            String endpoint;
            String endpointVal = endpoint = i$.next();
            if (endpoint.startsWith("//") && this.authority != null) {
                endpointVal = this.authority.getScheme() + ':' + endpoint;
            }
            endpointServices.putAll((Object)endpoint, this.retrieveServices(container, endpointVal.replace("%host%", host)));
        }
        return ImmutableMultimap.copyOf((Multimap)endpointServices);
    }

    protected List<String> getEndpointsFromContainerConfig(String container, String host) {
        Map properties = (Map)this.containerConfig.getMap(container, GADGETS_FEATURES_CONFIG).get(OSAPI_FEATURE_CONFIG);
        if (properties != null) {
            return (List)properties.get(OSAPI_BASE_ENDPOINTS);
        }
        return ImmutableList.of();
    }

    protected Set<String> retrieveServices(String container, String endpoint) {
        block8: {
            try {
                StringBuilder sb = new StringBuilder(250);
                sb.append(endpoint).append("?method=system.listMethods");
                HashMap parms = Maps.newHashMap();
                parms.put(AbstractSecurityToken.Keys.OWNER.getKey(), "-1");
                parms.put(AbstractSecurityToken.Keys.VIEWER.getKey(), "-1");
                parms.put(AbstractSecurityToken.Keys.APP_URL.getKey(), "0");
                BlobCrypterSecurityToken token = new BlobCrypterSecurityToken(container, "*", "0", (Map)parms);
                sb.append("&st=").append(this.codec.encodeToken((SecurityToken)token));
                Uri url = Uri.parse((String)sb.toString());
                HttpRequest request = new HttpRequest(url).setInternalRequest(true);
                HttpResponse response = this.fetcher.fetch(request);
                if (response.getHttpStatusCode() == 200) {
                    return this.getServicesFromJsonResponse(response.getResponseAsString());
                }
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.logp(Level.SEVERE, classname, "retrieveServices", "httpErrorFetching", new Object[]{response.getHttpStatusCode(), endpoint});
                }
            }
            catch (SecurityTokenException se) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.logp(Level.SEVERE, classname, "retrieveServices", "failedToFetchService", new Object[]{endpoint, se.getMessage()});
                }
            }
            catch (GadgetException ge) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.logp(Level.SEVERE, classname, "retrieveServices", "failedToFetchService", new Object[]{endpoint, ge.getMessage()});
                }
            }
            catch (JSONException je) {
                if (!LOG.isLoggable(Level.SEVERE)) break block8;
                LOG.logp(Level.SEVERE, classname, "retrieveServices", "failedToParseService", new Object[]{endpoint, je.getMessage()});
            }
        }
        return ImmutableSet.of();
    }

    protected Set<String> getServicesFromJsonResponse(String content) throws JSONException {
        ImmutableSet.Builder services = ImmutableSet.builder();
        JSONObject js = new JSONObject(content);
        JSONArray json = js.getJSONArray(JSON_RESPONSE_WRAPPER_ELEMENT);
        for (int i = 0; i < json.length(); ++i) {
            String o = json.getString(i);
            services.add((Object)o);
        }
        return services.build();
    }
}

