/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceInputStream;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.MultipleResourceHttpFetcher;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImageAttributeRewriter
extends DomWalker.Rewriter {
    private static final String classname = ImageAttributeRewriter.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");

    @Inject
    public ImageAttributeRewriter(RequestPipeline requestPipeline, ExecutorService executor) {
        super(new ImageAttributeVisitor(requestPipeline, executor));
    }

    public static class ImageAttributeVisitor
    implements DomWalker.Visitor {
        private final RequestPipeline requestPipeline;
        private final ExecutorService executor;
        private static final String IMG_ATTR_CLASS_NAME_PREFIX = "__shindig__image";

        public ImageAttributeVisitor(RequestPipeline requestPipeline, @Named(value="shindig.concat.executor") ExecutorService executor) {
            this.requestPipeline = requestPipeline;
            this.executor = executor;
        }

        @Override
        public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
            Element imageElement;
            if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("img") && "".equals((imageElement = (Element)node).getAttribute("class")) && "".equals(imageElement.getAttribute("id")) && !"".equals(imageElement.getAttribute("src")) && "".equals(imageElement.getAttribute("height")) && "".equals(imageElement.getAttribute("width"))) {
                return DomWalker.Visitor.VisitStatus.RESERVE_NODE;
            }
            return DomWalker.Visitor.VisitStatus.BYPASS;
        }

        @Override
        public boolean revisit(Gadget gadget, List<Node> nodes) throws RewritingException {
            if (nodes.isEmpty()) {
                return false;
            }
            Node head = DomUtil.getFirstNamedChildNode((Node)nodes.get(0).getOwnerDocument().getDocumentElement(), (String)"head");
            if (head == null) {
                return false;
            }
            ArrayList resourceRequests = Lists.newArrayList();
            for (Node node : nodes) {
                String imgSrc = ((Element)node).getAttribute("src");
                Uri uri = UriBuilder.parse((String)imgSrc).toUri();
                try {
                    resourceRequests.add(ImageAttributeVisitor.buildHttpRequest(gadget, uri));
                }
                catch (GadgetException e) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.logp(Level.WARNING, classname, "revisit", "unableToProcessImg", new Object[]{imgSrc});
                }
            }
            MultipleResourceHttpFetcher fetcher = new MultipleResourceHttpFetcher(this.requestPipeline, this.executor);
            Map<Uri, FutureTask<MultipleResourceHttpFetcher.RequestContext>> futureTasks = fetcher.fetchUnique(resourceRequests);
            String cssContent = this.processAllImgResources(nodes, futureTasks);
            if (cssContent.length() > 0) {
                Element style = nodes.get(0).getOwnerDocument().createElement("style");
                style.setAttribute("type", "text/css");
                style.setTextContent(cssContent);
                head.insertBefore(style, head.getFirstChild());
            }
            return true;
        }

        private String processAllImgResources(List<Node> nodes, Map<Uri, FutureTask<MultipleResourceHttpFetcher.RequestContext>> futureTasks) {
            StringBuilder cssContent = new StringBuilder("");
            for (int i = 0; i < nodes.size(); ++i) {
                Element imageElement = (Element)nodes.get(i);
                String src = imageElement.getAttribute("src");
                try {
                    ImageInfo imageInfo;
                    MultipleResourceHttpFetcher.RequestContext requestCxt;
                    Uri imgUri = UriBuilder.parse((String)src).toUri();
                    try {
                        requestCxt = futureTasks.get(imgUri).get();
                    }
                    catch (InterruptedException ie) {
                        throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)ie);
                    }
                    catch (ExecutionException ie) {
                        throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)ie);
                    }
                    if (requestCxt.getGadgetException() != null) {
                        throw requestCxt.getGadgetException();
                    }
                    HttpResponse response = requestCxt.getHttpResp();
                    ImageFormat imageFormat = Sanselan.guessFormat((ByteSource)new ByteSourceInputStream(response.getResponse(), imgUri.getPath()));
                    if (imageFormat == ImageFormat.IMAGE_FORMAT_UNKNOWN || (imageInfo = Sanselan.getImageInfo((InputStream)response.getResponse(), (String)imgUri.getPath())) == null) continue;
                    int imageHeight = imageInfo.getHeight();
                    int imageWidth = imageInfo.getWidth();
                    if (imageHeight <= 0 || imageWidth <= 0 || imageHeight * imageWidth <= 1) continue;
                    imageElement.setAttribute("class", IMG_ATTR_CLASS_NAME_PREFIX + i);
                    cssContent.append('.').append(IMG_ATTR_CLASS_NAME_PREFIX).append(i).append(" {\n").append("  height: ").append(imageHeight).append("px;\n").append("  width: ").append(imageWidth).append("px;\n").append("}\n");
                    continue;
                }
                catch (ImageReadException e) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.logp(Level.WARNING, classname, "processAllImgResources", "unableToReadResponse", new Object[]{src});
                    continue;
                }
                catch (GadgetException e) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.logp(Level.WARNING, classname, "processAllImgResources", "unableToFetchImg", new Object[]{src});
                    continue;
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.logp(Level.WARNING, classname, "processAllImgResources", "unableToParseImg", new Object[]{src});
                }
            }
            return cssContent.toString();
        }

        public static HttpRequest buildHttpRequest(Gadget gadget, Uri imgUri) throws GadgetException {
            HttpRequest req = new HttpRequest(imgUri);
            req.setFollowRedirects(true);
            return req;
        }
    }
}

