/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceInputStream;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.image.BMPOptimizer;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizer;
import org.apache.shindig.gadgets.rewrite.image.GIFOptimizer;
import org.apache.shindig.gadgets.rewrite.image.ImageUtils;
import org.apache.shindig.gadgets.rewrite.image.JPEGOptimizer;
import org.apache.shindig.gadgets.rewrite.image.JpegImageUtils;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.apache.shindig.gadgets.rewrite.image.PNGOptimizer;
import org.apache.shindig.gadgets.uri.UriCommon;

public class BasicImageRewriter
implements ResponseRewriter {
    static final String CONTENT_TYPE_AND_EXTENSION_MISMATCH = "Content is not an image but file extension asserts it is";
    static final String CONTENT_TYPE_AND_MIME_MISMATCH = "Content is not an image but mime type asserts it is";
    private static final String CONTENT_TYPE_IMAGE_PNG = "image/png";
    private static final String RESIZE_IMAGE_TOO_LARGE = "The image is too large to resize";
    private static final String RESIZE_OUTPUT_FORMAT = "png";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String PARAM_RESIZE_QUALITY = UriCommon.Param.RESIZE_QUALITY.getKey();
    private static final String PARAM_RESIZE_WIDTH = UriCommon.Param.RESIZE_WIDTH.getKey();
    private static final String PARAM_RESIZE_HEIGHT = UriCommon.Param.RESIZE_HEIGHT.getKey();
    private static final String PARAM_NO_EXPAND = UriCommon.Param.NO_EXPAND.getKey();
    private static final int BITS_PER_BYTE = 8;
    private static final Color COLOR_TRANSPARENT = new Color(255, 255, 255, 0);
    public static final String CONTENT_TYPE = "Content-Type";
    private static final String classname = BasicImageRewriter.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private static final Set<String> SUPPORTED_MIME_TYPES = ImmutableSet.of((Object)"image/gif", (Object)"image/png", (Object)"image/jpeg", (Object)"image/bmp");
    private static final Set<String> SUPPORTED_FILE_EXTENSIONS = ImmutableSet.of((Object)".gif", (Object)".png", (Object)".jpeg", (Object)".jpg", (Object)".bmp");
    private final OptimizerConfig config;

    @Inject
    public BasicImageRewriter(OptimizerConfig config) {
        this.config = config;
    }

    private Boolean canRewrite(HttpRequest request, HttpResponseBuilder response, ImageInfo imageInfo, Boolean isResizeRequested) {
        Uri uri = request.getUri();
        if (null == uri) {
            return false;
        }
        if (response.getContentLength() < this.config.getMinThresholdBytes()) {
            return false;
        }
        Integer resizeQuality = request.getParamAsInteger(PARAM_RESIZE_QUALITY);
        Integer requestedWidth = request.getParamAsInteger(PARAM_RESIZE_WIDTH);
        Integer requestedHeight = request.getParamAsInteger(PARAM_RESIZE_HEIGHT);
        if (!(this.isUsableParameter(requestedWidth) && this.isUsableParameter(requestedHeight) && this.isUsableParameter(resizeQuality))) {
            return false;
        }
        if (isResizeRequested.booleanValue() && this.isImageTooLarge(imageInfo)) {
            this.errorResponse(response, 403, RESIZE_IMAGE_TOO_LARGE);
            return false;
        }
        if (imageInfo.getNumberOfImages() > 1 || this.isImageTooLarge(imageInfo)) {
            return false;
        }
        return true;
    }

    private Boolean isResizeRequested(HttpRequest request, HttpResponseBuilder response, ImageInfo imageInfo) {
        Integer requestedWidth = request.getParamAsInteger(PARAM_RESIZE_WIDTH);
        Integer requestedHeight = request.getParamAsInteger(PARAM_RESIZE_HEIGHT);
        boolean resizeRequested = requestedWidth != null && this.isUsableParameter(requestedWidth) || requestedHeight != null && this.isUsableParameter(requestedHeight);
        boolean noExpand = "1".equals(request.getParam(PARAM_NO_EXPAND));
        if (!(!noExpand || requestedHeight != null && imageInfo.getHeight() > requestedHeight || requestedWidth != null && imageInfo.getWidth() > requestedWidth)) {
            resizeRequested = false;
        }
        return resizeRequested;
    }

    private ImageResizeData getResizeData(HttpRequest request, HttpResponseBuilder response, BufferedImage image, ImageInfo imageInfo) throws IOException {
        int origWidth = imageInfo.getWidth();
        int origHeight = imageInfo.getHeight();
        int widthDelta = 0;
        int heightDelta = 0;
        Integer requestedWidth = request.getParamAsInteger(PARAM_RESIZE_WIDTH);
        Integer requestedHeight = request.getParamAsInteger(PARAM_RESIZE_HEIGHT);
        if (requestedWidth == null || requestedHeight == null) {
            if (requestedWidth == null) {
                requestedWidth = Math.max(1, (int)((double)origWidth / (double)origHeight * (double)requestedHeight.intValue()));
            }
            if (requestedHeight == null) {
                requestedHeight = Math.max(1, (int)((double)origHeight / (double)origWidth * (double)requestedWidth.intValue()));
            }
        } else {
            double ratio = this.getResizeRatio(requestedWidth, requestedHeight, origWidth, origHeight);
            int widthAfterStep1 = Math.max(1, (int)Math.round(ratio * (double)origWidth));
            widthDelta = requestedWidth - widthAfterStep1;
            int heightAfterStep1 = Math.max(1, (int)Math.round(ratio * (double)origHeight));
            heightDelta = requestedHeight - heightAfterStep1;
            boolean noExpand = "1".equals(request.getParam(PARAM_NO_EXPAND));
            if (noExpand) {
                if (widthDelta == 0) {
                    requestedHeight = heightAfterStep1;
                    heightDelta = 0;
                } else if (heightDelta == 0) {
                    requestedWidth = widthAfterStep1;
                    widthDelta = 0;
                }
            }
        }
        if (this.isResizeRequired(requestedWidth, requestedHeight, imageInfo) && !this.isTargetImageTooLarge(requestedWidth, requestedHeight, imageInfo)) {
            return new ImageResizeData(requestedWidth, requestedHeight, widthDelta, heightDelta);
        }
        return null;
    }

    @Override
    public void rewrite(HttpRequest request, HttpResponseBuilder response, Gadget gadget) {
        block13: {
            if (request == null || response == null) {
                return;
            }
            Uri uri = request.getUri();
            if (null == uri) {
                return;
            }
            try {
                ImageResizeData resizeData;
                Boolean resizeRequested;
                if (!this.isSupportedImageResult(response, uri)) {
                    return;
                }
                ImageFormat imageFormat = Sanselan.guessFormat((ByteSource)new ByteSourceInputStream(response.getContentBytes(), uri.getPath()));
                if (imageFormat == ImageFormat.IMAGE_FORMAT_UNKNOWN) {
                    this.enforceUnreadableImageRestrictions(uri, response);
                    return;
                }
                ImageInfo imageInfo = Sanselan.getImageInfo((InputStream)response.getContentBytes(), (String)uri.getPath());
                if (!this.canRewrite(request, response, imageInfo, resizeRequested = this.isResizeRequested(request, response, imageInfo)).booleanValue()) {
                    return;
                }
                JpegImageUtils.JpegImageParams jpegImageParams = null;
                if (imageFormat == ImageFormat.IMAGE_FORMAT_JPEG) {
                    jpegImageParams = JpegImageUtils.getJpegImageData(response.getContentBytes(), uri.getPath());
                }
                BufferedImage image = this.readImage(imageFormat, response);
                if (resizeRequested.booleanValue() && (resizeData = this.getResizeData(request, response, image, imageInfo)) != null) {
                    image = this.resizeImage(image, resizeData.getWidth(), resizeData.getHeight(), resizeData.getWidthDelta(), resizeData.getHeightDelta());
                    this.updateResponse(response, image);
                }
                this.applyOptimizer(response, imageFormat, jpegImageParams, image, this.config);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.logp(Level.WARNING, classname, "rewrite", "ioErrorRewritingImg", new Object[]{request.toString(), ioe.getMessage()});
                }
            }
            catch (RuntimeException re) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.INFO, classname, "rewrite", "unknownErrorRewritingImg", new Object[]{request.toString(), re.getMessage()});
                }
            }
            catch (ImageReadException ire) {
                if (!LOG.isLoggable(Level.INFO)) break block13;
                LOG.logp(Level.INFO, classname, "rewrite", "failedToReadImg", new Object[]{request.toString(), ire.getMessage()});
            }
        }
    }

    public void updateResponse(HttpResponseBuilder response, BufferedImage image) throws IOException {
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName(RESIZE_OUTPUT_FORMAT).next();
        BaseOptimizer.ImageIOOutputter outputter = new BaseOptimizer.ImageIOOutputter(imageWriter, null);
        byte[] imageBytes = outputter.toBytes(image);
        response.setResponse(imageBytes).setHeader(CONTENT_TYPE, CONTENT_TYPE_IMAGE_PNG).setHeader(CONTENT_LENGTH, String.valueOf(imageBytes.length));
    }

    private boolean isUsableParameter(Integer parameterValue) {
        if (parameterValue == null) {
            return true;
        }
        return parameterValue > 0;
    }

    private double getResizeRatio(int requestedWidth, int requestedHeight, int origWidth, int origHeight) {
        return Math.min((double)requestedWidth / (double)origWidth, (double)requestedHeight / (double)origHeight);
    }

    public BufferedImage resizeImage(BufferedImage image, Integer requestedWidth, Integer requestedHeight, int extraWidth, int extraHeight) {
        int imageType;
        int heightStretch;
        int widthStretch = requestedWidth - extraWidth;
        if ((image = ImageUtils.getScaledInstance(image, widthStretch, heightStretch = requestedHeight - extraHeight, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true, imageType = ImageUtils.isOpaque(image) ? 5 : 2)).getWidth() != requestedWidth.intValue() || image.getHeight() != requestedHeight.intValue()) {
            image = this.stretchImage(image, requestedWidth, requestedHeight, imageType);
        }
        return image;
    }

    private BufferedImage stretchImage(BufferedImage image, Integer requestedWidth, Integer requestedHeight, int imageType) {
        BufferedImage scaledImage = new BufferedImage(requestedWidth, requestedHeight, imageType);
        Graphics2D g2d = scaledImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.fillWithTransparent(g2d, requestedWidth, requestedHeight);
        g2d.drawImage(image, 0, 0, requestedWidth, requestedHeight, null);
        image = scaledImage;
        return image;
    }

    private void fillWithTransparent(Graphics2D g2d, Integer requestedWidth, Integer requestedHeight) {
        g2d.setComposite(AlphaComposite.Clear);
        g2d.setColor(COLOR_TRANSPARENT);
        g2d.fillRect(0, 0, requestedWidth, requestedHeight);
        g2d.setComposite(AlphaComposite.SrcOver);
    }

    protected void applyOptimizer(HttpResponseBuilder response, ImageFormat imageFormat, JpegImageUtils.JpegImageParams jpegImageParams, BufferedImage image, OptimizerConfig config) throws IOException {
        if (imageFormat == ImageFormat.IMAGE_FORMAT_GIF) {
            if (!response.create().getResponseAsString().contains("NETSCAPE2.0")) {
                new GIFOptimizer(config, response).rewrite(image);
            }
        } else if (imageFormat == ImageFormat.IMAGE_FORMAT_PNG) {
            new PNGOptimizer(config, response).rewrite(image);
        } else if (imageFormat == ImageFormat.IMAGE_FORMAT_JPEG) {
            new JPEGOptimizer(config, response, jpegImageParams).rewrite(image);
        } else if (imageFormat == ImageFormat.IMAGE_FORMAT_BMP) {
            new BMPOptimizer(config, response).rewrite(image);
        }
    }

    private boolean isImageTooLarge(ImageInfo imageInfo) {
        return this.isTargetImageTooLarge(imageInfo.getWidth(), imageInfo.getHeight(), imageInfo);
    }

    private boolean isTargetImageTooLarge(int requestedHeight, int requestedWidth, ImageInfo imageInfo) {
        long imagePixels = Math.abs(requestedHeight) * Math.abs(requestedWidth);
        long imageSizeBits = imagePixels * (long)imageInfo.getBitsPerPixel();
        return imageSizeBits > (long)(this.config.getMaxInMemoryBytes() * 8);
    }

    protected boolean isSupportedImageResult(HttpResponseBuilder response, Uri uri) {
        return this.isSupportedContent(response) || this.isImageUri(uri);
    }

    protected boolean isSupportedContent(HttpResponseBuilder response) {
        return SUPPORTED_MIME_TYPES.contains(response.getHeader(CONTENT_TYPE));
    }

    protected boolean isImageUri(Uri uri) {
        boolean pathExtMatches = false;
        for (String ext : SUPPORTED_FILE_EXTENSIONS) {
            if (!uri.getPath().endsWith(ext)) continue;
            pathExtMatches = true;
            break;
        }
        return pathExtMatches;
    }

    private boolean isResizeRequired(int resize_w, int resize_h, ImageInfo imageInfo) {
        return resize_w != imageInfo.getWidth() || resize_h != imageInfo.getHeight();
    }

    protected void enforceUnreadableImageRestrictions(Uri uri, HttpResponseBuilder response) {
        String contentType = response.getHeader(CONTENT_TYPE);
        if (contentType != null) {
            contentType = contentType.toLowerCase();
            for (String expected : SUPPORTED_MIME_TYPES) {
                if (!contentType.contains(expected)) continue;
                this.errorResponse(response, 415, CONTENT_TYPE_AND_MIME_MISMATCH);
                return;
            }
        }
        String path = uri.getPath().toLowerCase();
        for (String supportedExtension : SUPPORTED_FILE_EXTENSIONS) {
            if (!path.endsWith(supportedExtension)) continue;
            this.errorResponse(response, 415, CONTENT_TYPE_AND_EXTENSION_MISMATCH);
            return;
        }
    }

    private void errorResponse(HttpResponseBuilder response, int status, String msg) {
        response.clearAllHeaders().setHttpStatusCode(status).setResponseString(msg);
    }

    protected BufferedImage readImage(ImageFormat imageFormat, HttpResponseBuilder response) throws ImageReadException, IOException {
        if (imageFormat == ImageFormat.IMAGE_FORMAT_GIF) {
            return this.readGif(response);
        }
        if (imageFormat == ImageFormat.IMAGE_FORMAT_PNG) {
            return this.readPng(response);
        }
        if (imageFormat == ImageFormat.IMAGE_FORMAT_JPEG) {
            return this.readJpeg(response);
        }
        if (imageFormat == ImageFormat.IMAGE_FORMAT_BMP) {
            return this.readBmp(response);
        }
        throw new ImageReadException("Unsupported format " + imageFormat.name);
    }

    protected BufferedImage readBmp(HttpResponseBuilder response) throws ImageReadException, IOException {
        return BMPOptimizer.readBmp(response.getContentBytes());
    }

    protected BufferedImage readPng(HttpResponseBuilder response) throws ImageReadException, IOException {
        return PNGOptimizer.readPng(response.getContentBytes());
    }

    protected BufferedImage readGif(HttpResponseBuilder response) throws ImageReadException, IOException {
        return GIFOptimizer.readGif(response.getContentBytes());
    }

    protected BufferedImage readJpeg(HttpResponseBuilder response) throws ImageReadException, IOException {
        return JPEGOptimizer.readJpeg(response.getContentBytes());
    }

    private static class ImageResizeData {
        private Integer requestedWidth;
        private Integer requestedHeight;
        private Integer widthDelta;
        private Integer heightDelta;

        protected ImageResizeData(Integer requestedWidth, Integer requestedHeight, Integer widthDelta, Integer heightDelta) {
            this.requestedWidth = requestedWidth;
            this.requestedHeight = requestedHeight;
            this.widthDelta = widthDelta;
            this.heightDelta = heightDelta;
        }

        public Integer getWidth() {
            return this.requestedWidth;
        }

        public Integer getHeight() {
            return this.requestedHeight;
        }

        public Integer getWidthDelta() {
            return this.widthDelta;
        }

        public Integer getHeightDelta() {
            return this.heightDelta;
        }
    }
}

