/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.MultipleResourceHttpFetcher;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterList;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.uri.ConcatUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;

public class ConcatProxyServlet
extends InjectedServlet {
    private static final long serialVersionUID = -4390212150673709895L;
    public static final String JSON_PARAM = UriCommon.Param.JSON.getKey();
    private static final Pattern JSON_PARAM_PATTERN = Pattern.compile("^\\w*$");
    static final Integer LONG_LIVED_REFRESH = 31536000;
    static final Integer DEFAULT_REFRESH = 3600;
    private static final String classname = ConcatProxyServlet.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private transient RequestPipeline requestPipeline;
    private transient ConcatUriManager concatUriManager;
    private transient ResponseRewriterRegistry contentRewriterRegistry;
    private transient Executor executor = Executors.newSingleThreadExecutor();
    private Integer longLivedRefreshSec = LONG_LIVED_REFRESH;

    @Inject(optional=true)
    public void setLongLivedRefresh(@Named(value="org.apache.shindig.gadgets.servlet.longLivedRefreshSec") int longLivedRefreshSec) {
        this.longLivedRefreshSec = longLivedRefreshSec;
    }

    @Inject
    public void setRequestPipeline(RequestPipeline requestPipeline) {
        this.checkInitialized();
        this.requestPipeline = requestPipeline;
    }

    @Inject
    public void setConcatUriManager(ConcatUriManager concatUriManager) {
        this.checkInitialized();
        this.concatUriManager = concatUriManager;
    }

    @Inject
    public void setContentRewriterRegistry(@RewriterRegistry(rewriteFlow=ResponseRewriterList.RewriteFlow.DEFAULT) ResponseRewriterRegistry contentRewriterRegistry) {
        this.checkInitialized();
        this.contentRewriterRegistry = contentRewriterRegistry;
    }

    @Inject
    public void setExecutor(@Named(value="shindig.concat.executor") Executor executor) {
        this.checkInitialized();
        this.executor = executor;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getHeader("If-Modified-Since") != null) {
            response.setStatus(304);
            return;
        }
        Uri uri = new UriBuilder(request).toUri();
        ConcatUriManager.ConcatUri concatUri = this.concatUriManager.process(uri);
        ConcatUriManager.Type concatType = concatUri.getType();
        try {
            if (concatType == null) {
                throw new GadgetException(GadgetException.Code.MISSING_PARAMETER, "Missing type", 400);
            }
        }
        catch (GadgetException gex) {
            response.sendError(400, ConcatProxyServlet.formatError("doGet", gex, uri));
            return;
        }
        response.setHeader("Content-Type", concatType.getMimeType() + "; charset=UTF8");
        response.setHeader("Content-Disposition", "attachment;filename=p.txt");
        ConcatOutputStream cos = this.createConcatOutputStream(response, concatUri);
        if (cos == null) {
            response.setStatus(400);
            response.getOutputStream().println(ConcatProxyServlet.formatHttpError(400, "Bad json variable name " + concatUri.getSplitParam(), null));
        } else {
            if (this.doFetchConcatResources(response, concatUri, uri, cos)) {
                response.setStatus(200);
            } else {
                response.setStatus(400);
            }
            IOUtils.closeQuietly((OutputStream)((Object)cos));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ConcatOutputStream createConcatOutputStream(HttpServletResponse response, ConcatUriManager.ConcatUri concatUri) throws IOException {
        void var3_6;
        String jsonVar = concatUri.getSplitParam();
        if (jsonVar != null) {
            if (!JSON_PARAM_PATTERN.matcher(jsonVar).matches()) return null;
            JsonConcatOutputStream jsonConcatOutputStream = new JsonConcatOutputStream(response.getOutputStream(), jsonVar);
            return var3_6;
        } else {
            VerbatimConcatOutputStream verbatimConcatOutputStream = new VerbatimConcatOutputStream(response.getOutputStream());
        }
        return var3_6;
    }

    private boolean doFetchConcatResources(HttpServletResponse response, ConcatUriManager.ConcatUri concatUri, Uri uri, ConcatOutputStream cos) throws IOException {
        Long minCacheTtl = Long.MAX_VALUE;
        boolean isMinCacheTtlSet = false;
        ArrayList requests = Lists.newArrayList();
        try {
            for (Uri resourceUri : concatUri.getBatch()) {
                try {
                    requests.add(concatUri.makeHttpRequest(resourceUri));
                }
                catch (GadgetException ge) {
                    if (!cos.outputError(resourceUri, ge)) continue;
                    return false;
                }
            }
            MultipleResourceHttpFetcher parallelFetcher = new MultipleResourceHttpFetcher(this.requestPipeline, this.executor);
            List<Pair<Uri, FutureTask<MultipleResourceHttpFetcher.RequestContext>>> futureTasks = parallelFetcher.fetchAll(requests);
            for (Pair<Uri, FutureTask<MultipleResourceHttpFetcher.RequestContext>> futureTask : futureTasks) {
                try {
                    MultipleResourceHttpFetcher.RequestContext requestCxt;
                    try {
                        requestCxt = (MultipleResourceHttpFetcher.RequestContext)((FutureTask)futureTask.two).get();
                    }
                    catch (InterruptedException ie) {
                        throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)ie);
                    }
                    catch (ExecutionException ee) {
                        throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)ee);
                    }
                    if (requestCxt.getGadgetException() != null) {
                        throw requestCxt.getGadgetException();
                    }
                    HttpResponse httpResp = requestCxt.getHttpResp();
                    if (httpResp != null) {
                        if (this.contentRewriterRegistry != null) {
                            try {
                                httpResp = this.contentRewriterRegistry.rewriteHttpResponse(requestCxt.getHttpReq(), httpResp, null);
                            }
                            catch (RewritingException e) {
                                throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, e, e.getHttpStatusCode());
                            }
                        }
                        minCacheTtl = Math.min(minCacheTtl, httpResp.getCacheTtl());
                        isMinCacheTtlSet = true;
                        cos.output((Uri)futureTask.one, httpResp);
                        continue;
                    }
                    return false;
                }
                catch (GadgetException ge) {
                    if (!cos.outputError((Uri)futureTask.one, ge)) continue;
                    return false;
                }
            }
            minCacheTtl = isMinCacheTtlSet ? minCacheTtl / 1000L : (long)DEFAULT_REFRESH.intValue();
            HttpUtil.setCachingHeaders((HttpServletResponse)response, (int)concatUri.translateStatusRefresh(this.longLivedRefreshSec, minCacheTtl.intValue()), (boolean)false);
        }
        catch (GadgetException gex) {
            cos.outputError(uri, gex);
        }
        return true;
    }

    private static String formatHttpError(int status, String errorMessage, Uri uri) {
        StringBuilder err = new StringBuilder();
        err.append("/* ---- Error ");
        err.append(status);
        if (!Strings.isNullOrEmpty((String)errorMessage)) {
            err.append(", ");
            err.append(errorMessage);
        }
        if (uri != null) {
            err.append(" (").append(uri.toString()).append(')');
        }
        err.append(" ---- */");
        return err.toString();
    }

    private static String formatError(String methodname, GadgetException excep, Uri uri) throws IOException {
        StringBuilder err = new StringBuilder();
        err.append("/* ---- Error ");
        err.append(excep.getCode().toString());
        err.append(" concat(");
        err.append(uri.toString());
        err.append(") ");
        err.append(excep.getMessage());
        err.append(" ---- */");
        if (LOG.isLoggable(Level.INFO)) {
            LOG.logp(Level.INFO, classname, methodname, "concatProxyRequestFailed", new Object[]{err.toString()});
        }
        return err.toString();
    }

    private static class JsonConcatOutputStream
    extends ConcatOutputStream {
        private boolean firstEntry;

        public JsonConcatOutputStream(ServletOutputStream wrapped, String tok) throws IOException {
            super(wrapped);
            this.println(tok + "={");
            this.firstEntry = true;
        }

        @Override
        protected void outputJs(Uri uri, String data) throws IOException {
            if (!this.firstEntry) {
                this.println(",");
            }
            this.firstEntry = false;
            this.print("\"");
            this.print(uri.toString());
            this.print("\":\"");
            this.print(StringEscapeUtils.escapeEcmaScript((String)data));
            this.print("\"");
        }

        @Override
        public void close() throws IOException {
            this.println("};");
            super.close();
        }
    }

    private static class VerbatimConcatOutputStream
    extends ConcatOutputStream {
        public VerbatimConcatOutputStream(ServletOutputStream wrapped) {
            super(wrapped);
        }

        @Override
        protected void outputJs(Uri uri, String data) throws IOException {
            this.println("/* ---- Start " + uri.toString() + " ---- */");
            this.print(data);
            this.println("/* ---- End " + uri.toString() + " ---- */");
        }
    }

    private static abstract class ConcatOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream wrapped;
        private final StringBuilder stringBuilder;
        private String CRLF = "\r\n";

        protected ConcatOutputStream(ServletOutputStream wrapped) {
            this.wrapped = wrapped;
            this.stringBuilder = new StringBuilder();
        }

        protected abstract void outputJs(Uri var1, String var2) throws IOException;

        public void output(Uri uri, HttpResponse resp) throws IOException {
            if (resp.getHttpStatusCode() != 200) {
                this.println(ConcatProxyServlet.formatHttpError(resp.getHttpStatusCode(), resp.getResponseAsString(), uri));
            } else {
                this.outputJs(uri, resp.getResponseAsString());
            }
        }

        public boolean outputError(Uri uri, GadgetException e) throws IOException {
            this.println(ConcatProxyServlet.formatError("outputError", e, uri));
            return e.getHttpStatusCode() == 500;
        }

        public void write(int b) throws IOException {
            this.wrapped.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.wrapped.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.wrapped.write(b);
        }

        public void close() throws IOException {
            this.wrapped.write(CharsetUtil.getUtf8Bytes((String)this.stringBuilder.toString()));
            this.wrapped.close();
        }

        public void print(String data) throws IOException {
            this.stringBuilder.append(data);
        }

        public void println(String data) throws IOException {
            this.print(data + this.CRLF);
        }
    }
}

