/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.admin.GadgetAdminStore;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterList;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.servlet.ServletUtil;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.gadgets.uri.UriUtils;

@Singleton
public class ProxyHandler {
    private final RequestPipeline requestPipeline;
    private final ResponseRewriterRegistry contentRewriterRegistry;
    protected final boolean remapInternalServerError;
    private final GadgetAdminStore gadgetAdminStore;
    private final Integer longLivedRefreshSec;
    private static final String POST = "POST";
    private static final String FLASH_CONTENT_TYPE = "application/x-shockwave-flash";

    @Inject
    public ProxyHandler(RequestPipeline requestPipeline, @RewriterRegistry(rewriteFlow=ResponseRewriterList.RewriteFlow.DEFAULT) ResponseRewriterRegistry contentRewriterRegistry, @Named(value="shindig.proxy.remapInternalServerError") Boolean remapInternalServerError, GadgetAdminStore gadgetAdminStore, @Named(value="org.apache.shindig.gadgets.servlet.longLivedRefreshSec") int longLivedRefreshSec) {
        this.requestPipeline = requestPipeline;
        this.contentRewriterRegistry = contentRewriterRegistry;
        this.remapInternalServerError = remapInternalServerError;
        this.gadgetAdminStore = gadgetAdminStore;
        this.longLivedRefreshSec = longLivedRefreshSec;
    }

    private HttpRequest buildHttpRequest(ProxyUriManager.ProxyUri uriCtx, Uri tgt, @Nullable String postBody) throws GadgetException, IOException {
        String userAgent;
        ServletUtil.validateUrl(tgt);
        HttpRequest req = uriCtx.makeHttpRequest(tgt);
        req.setRewriteMimeType(uriCtx.getRewriteMimeType());
        if (postBody != null) {
            req.setMethod(POST);
            req.setPostBody(new ByteArrayInputStream(postBody.getBytes()));
        }
        if (req.getHeader("User-Agent") == null && (userAgent = uriCtx.getUserAgent()) != null) {
            req.setHeader("User-Agent", userAgent);
        }
        return req;
    }

    public HttpResponse fetch(ProxyUriManager.ProxyUri proxyUri) throws IOException, GadgetException {
        return this.fetch(proxyUri, null);
    }

    public HttpResponse fetch(ProxyUriManager.ProxyUri proxyUri, @Nullable String postBody) throws IOException, GadgetException {
        HttpResponse results;
        HttpRequest rcr;
        block8: {
            Uri fallbackUri;
            rcr = this.buildHttpRequest(proxyUri, proxyUri.getResource(), postBody);
            if (rcr == null) {
                throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "No url parameter in request", 400);
            }
            if (rcr.getGadget() != null && !this.gadgetAdminStore.isWhitelisted(rcr.getContainer(), rcr.getGadget().toString())) {
                throw new GadgetException(GadgetException.Code.NON_WHITELISTED_GADGET, "The requested content is unavailable", 403);
            }
            results = this.requestPipeline.execute(rcr);
            if (results.isError() && (fallbackUri = proxyUri.getFallbackUri()) != null) {
                HttpRequest fallbackRcr = this.buildHttpRequest(proxyUri, fallbackUri, null);
                results = this.requestPipeline.execute(fallbackRcr);
            }
            if (this.contentRewriterRegistry != null) {
                try {
                    results = this.contentRewriterRegistry.rewriteHttpResponse(rcr, results, null);
                }
                catch (RewritingException e) {
                    if (proxyUri.shouldReturnOrigOnErr() && this.isRecoverable(results)) break block8;
                    throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, e, e.getHttpStatusCode());
                }
            }
        }
        HttpResponseBuilder response = new HttpResponseBuilder(results);
        response.clearAllHeaders();
        try {
            ServletUtil.setCachingHeaders(response, proxyUri.translateStatusRefresh(this.longLivedRefreshSec, (int)(results.getCacheTtl() / 1000L)), false);
        }
        catch (GadgetException gex) {
            return ServletUtil.errorResponse(gex);
        }
        UriUtils.copyResponseHeadersAndStatusCode(results, response, this.remapInternalServerError, true, UriUtils.DisallowedHeaders.CACHING_DIRECTIVES, UriUtils.DisallowedHeaders.CLIENT_STATE_DIRECTIVES, UriUtils.DisallowedHeaders.OUTPUT_TRANSFER_DIRECTIVES);
        this.setResponseContentHeaders(response, results);
        UriUtils.maybeRewriteContentType(rcr, response);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)results.getResponse(), (OutputStream)baos);
        response.setResponse(baos.toByteArray());
        return response.create();
    }

    protected void setResponseContentHeaders(HttpResponseBuilder response, HttpResponse results) {
        if (!this.isFlash(response.getHeader("Content-Type"), results.getHeader("Content-Type"))) {
            String contentDispositionValue = results.getHeader("Content-Disposition");
            if (StringUtils.isBlank((CharSequence)contentDispositionValue) || contentDispositionValue.indexOf("attachment;") == -1 || contentDispositionValue.indexOf("filename") == -1) {
                response.setHeader("Content-Disposition", "attachment;filename=p.txt");
            } else {
                response.setHeader("Content-Disposition", contentDispositionValue);
            }
        }
        if (results.getHeader("Content-Type") == null) {
            response.setHeader("Content-Type", "application/octet-stream");
        }
    }

    private boolean isFlash(String responseContentType, String resultsContentType) {
        return StringUtils.startsWithIgnoreCase((CharSequence)responseContentType, (CharSequence)FLASH_CONTENT_TYPE) || StringUtils.startsWithIgnoreCase((CharSequence)resultsContentType, (CharSequence)FLASH_CONTENT_TYPE);
    }

    public boolean isRecoverable(HttpResponse results) {
        return !Strings.isNullOrEmpty((String)results.getResponseAsString()) || results.getHeaders() != null;
    }
}

