/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.apache.shindig.gadgets.uri.UriStatus;

public class AllJsIframeVersioner
implements IframeUriManager.Versioner {
    private final String allJsChecksum;

    @Inject
    public AllJsIframeVersioner(FeatureRegistry registry) {
        String charset = Charset.defaultCharset().name();
        MessageDigest digest = HashUtil.getMessageDigest();
        digest.reset();
        for (FeatureResource resource : registry.getAllFeatures().getResources()) {
            this.update(digest, resource.getContent(), charset);
            this.update(digest, resource.getDebugContent(), charset);
        }
        this.allJsChecksum = HashUtil.bytesToHex((byte[])digest.digest());
    }

    private void update(MessageDigest digest, String content, String charset) {
        try {
            digest.update((content == null ? "null" : content).getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            digest.update((content == null ? "null" : content).getBytes());
        }
    }

    @Override
    public String version(Uri gadgetUri, String container) {
        return this.allJsChecksum;
    }

    @Override
    public UriStatus validate(Uri gadgetUri, String container, String value) {
        if (value == null || value.length() == 0) {
            return UriStatus.VALID_UNVERSIONED;
        }
        if (value.equals(this.allJsChecksum)) {
            return UriStatus.VALID_VERSIONED;
        }
        return UriStatus.INVALID_VERSION;
    }
}

