/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.plugin.doc.ComposerFileItem;
import org.exoplatform.social.plugin.doc.UIAbstractSelectFileComposer;
import org.exoplatform.social.plugin.doc.UIDocActivityPopup;
import org.exoplatform.social.plugin.doc.selector.UIDocumentSelectorUpdate;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.cssfile.CssClassManager;
import org.exoplatform.webui.cssfile.CssClassUtils;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/social/plugin/doc/selector/UIDocumentSelector.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UIDocumentSelector
extends UIAbstractSelectFileComposer {
    public static final String ACTIVITY_PARAMS_SEPARATOR = "/@/";
    public static final String DOCUMENTS_BREADCRUMB_SELECTOR = "DocumentsBreadcumbSelector";
    private static final String ALL_GROUP_PERMISSION = "*:${groupId}";
    private static final String ALL_USER_PERMISSION = "${userId}";
    private static final String UPLOAD_RESOLVER_TYPE = "JCR";
    private static final Log LOG = ExoLogger.getLogger((String)UIDocumentSelector.class.getName());
    protected String documentSelectorTitle;
    private ManageDriveService driveService;
    private SpaceService spaceService;
    private LinkManager linkManager;
    private List<Object> breadCrumb = new ArrayList<Object>();
    private List<String> breadCrumbTitle = new ArrayList<String>();
    private List<String> selectedFilePaths = new ArrayList<String>();
    private List<String> selectedFileTitles = new ArrayList<String>();
    private List<String> validSelectedFilePaths = new ArrayList<String>();
    private String lastSelectedDocumentTitle = null;
    private boolean documentAlreadySelectedError = false;

    public UIDocumentSelector() throws Exception {
        this.driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        this.linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
        Iterator<DriveData> drives = this.getDrives().iterator();
        DriveData selectedDriveData = null;
        try {
            if (StringUtils.isBlank((String)SpaceUtils.getSpaceUrlByContext())) {
                while (drives.hasNext() && selectedDriveData == null) {
                    DriveData driveData = drives.next();
                    if (!driveData.getName().equals("Personal Documents")) continue;
                    selectedDriveData = driveData;
                }
            } else {
                Space space = this.spaceService.getSpaceByUrl(SpaceUtils.getSpaceUrlByContext());
                while (drives.hasNext() && selectedDriveData == null) {
                    DriveData driveData = drives.next();
                    if (!driveData.getHomePath().contains(space.getGroupId())) continue;
                    selectedDriveData = driveData;
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while initializing Popup", (Throwable)e);
        }
        if (selectedDriveData != null) {
            this.breadCrumb.clear();
            this.breadCrumbTitle.clear();
            this.breadCrumb.add(selectedDriveData);
            this.breadCrumbTitle.add(this.getDriveTitle(selectedDriveData));
        }
        this.addChild(UIDocumentSelectorUpdate.class, null, null);
    }

    public String getLastSelectedDocumentTitle() {
        return this.lastSelectedDocumentTitle;
    }

    public boolean isDocumentAlreadySelectedError() {
        return this.documentAlreadySelectedError;
    }

    public void setDocumentAlreadySelectedError(boolean documentAlreadySelectedError) {
        this.documentAlreadySelectedError = documentAlreadySelectedError;
    }

    public void setTitle(String documentSelectorTitle) {
        this.documentSelectorTitle = documentSelectorTitle;
    }

    public String getTitle() {
        return this.documentSelectorTitle;
    }

    public List<DriveData> getDrives() throws Exception {
        if (this.breadCrumb.isEmpty()) {
            ArrayList<DriveData> driveDatas = new ArrayList<DriveData>();
            driveDatas.addAll(this.driveService.getMainDrives(Util.getPortalRequestContext().getRemoteUser(), org.exoplatform.ecm.webui.utils.Utils.getMemberships()));
            driveDatas.addAll(this.driveService.getGroupDrives(Util.getPortalRequestContext().getRemoteUser(), org.exoplatform.ecm.webui.utils.Utils.getMemberships()));
            driveDatas.addAll(this.driveService.getPersonalDrives(Util.getPortalRequestContext().getRemoteUser()));
            return driveDatas;
        }
        return Collections.emptyList();
    }

    public List<Node> getFolders() throws Exception {
        if (this.breadCrumb.isEmpty()) {
            return Collections.emptyList();
        }
        DriveData drive = (DriveData)this.breadCrumb.get(0);
        String path = null;
        path = this.breadCrumb.size() == 1 ? this.getDriveHomePath(drive) : (String)this.breadCrumb.get(this.breadCrumb.size() - 1);
        Node docNode = NodeLocation.getNodeByExpression((String)(WCMCoreUtils.getRepository().getConfiguration().getName() + ":" + drive.getWorkspace() + ":" + path));
        ArrayList<Node> folderNodes = new ArrayList<Node>();
        NodeIterator nodesIterator = docNode.getNodes();
        while (nodesIterator.hasNext()) {
            Node node = nodesIterator.nextNode();
            if (node.isNodeType("exo:hiddenable")) continue;
            if (node.isNodeType("exo:symlink") && node.hasProperty("exo:uuid") && node.hasProperty("exo:workspace")) {
                node = this.linkManager.getTarget(node);
            }
            if (!node.isNodeType("nt:folder") && !node.isNodeType("nt:unstructured")) continue;
            folderNodes.add(node);
        }
        return folderNodes;
    }

    public List<Node> getFiles() throws Exception {
        if (this.breadCrumb.isEmpty()) {
            return Collections.emptyList();
        }
        DriveData drive = (DriveData)this.breadCrumb.get(0);
        String path = null;
        path = this.breadCrumb.size() == 1 ? this.getDriveHomePath(drive) : (String)this.breadCrumb.get(this.breadCrumb.size() - 1);
        Node docNode = NodeLocation.getNodeByExpression((String)(WCMCoreUtils.getRepository().getConfiguration().getName() + ":" + drive.getWorkspace() + ":" + path));
        ArrayList<Node> fileNodes = new ArrayList<Node>();
        NodeIterator nodesIterator = docNode.getNodes();
        while (nodesIterator.hasNext()) {
            Node node = nodesIterator.nextNode();
            if (node.isNodeType("exo:hiddenable")) continue;
            if (node.isNodeType("exo:symlink") && node.hasProperty("exo:uuid") && node.hasProperty("exo:workspace")) {
                node = this.linkManager.getTarget(node);
            }
            if (!node.isNodeType("nt:file") || fileNodes.contains(node)) continue;
            fileNodes.add(node);
        }
        return fileNodes;
    }

    public String getDriveTitle(DriveData drive) throws Exception {
        String name = drive.getName();
        if (name.startsWith(".")) {
            String groupLabel = this.getGroupLabel(drive);
            if (groupLabel == null) {
                groupLabel = this.getGroupLabel(name, !name.startsWith("/spaces"));
            }
            return groupLabel;
        }
        return this.getLabel(name);
    }

    public String getDriveCSSClasses(DriveData drive) throws Exception {
        if (drive.getName().startsWith(".")) {
            return "uiIconEcms24x24Drive" + drive.getName().replaceAll(" ", "") + " uiIconEcms24x24DriveGroup";
        }
        if (drive.getHomePath().contains(ALL_USER_PERMISSION)) {
            return "uiIconEcms24x24Drive" + drive.getName().replaceAll(" ", "") + " uiIconEcms24x24DrivePrivate";
        }
        return "uiIconEcms24x24Drive" + drive.getName().replaceAll(" ", "") + " uiIconEcms24x24DriveGeneral";
    }

    public String getLabel(String id) {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            PortalRequestContext ctx;
            String userDisplayName = "";
            if ("User Documents".equals(id) && (ctx = Util.getPortalRequestContext()) != null) {
                String username = ctx.getRemoteUser();
                try {
                    User user = ((OrganizationService)this.getApplicationComponent(OrganizationService.class)).getUserHandler().findUserByName(username);
                    if (user != null) {
                        userDisplayName = user.getDisplayName();
                    }
                }
                catch (Exception ex) {
                    userDisplayName = username;
                }
            }
            return res.getString("Drives.label." + id.replace(" ", "")).replace("{0}", userDisplayName);
        }
        catch (Exception ex) {
            return id;
        }
    }

    public String getGroupLabel(DriveData driveData) throws Exception {
        try {
            RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
            String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
            String absPath = groupPath + driveData.getName().replace(".", "/");
            ManageableRepository currentRepository = repoService.getCurrentRepository();
            String workspace = currentRepository.getConfiguration().getDefaultWorkspaceName();
            return this.getNode(workspace, absPath).getProperty("exo:driveLabel").getString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Node getNode(String workspace, String absPath) throws Exception {
        RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository currentRepository = repoService.getCurrentRepository();
        Node groupNode = (Node)WCMCoreUtils.getSystemSessionProvider().getSession(workspace, currentRepository).getItem(absPath);
        return groupNode;
    }

    public String getGroupLabel(String groupId, boolean isFull) {
        String ret = groupId.replace(".", " / ");
        if (!isFull) {
            if (ret.startsWith(" / spaces")) {
                return ret.substring(ret.lastIndexOf("/") + 1).trim();
            }
            int count = 0;
            int slashPosition = -1;
            for (int i = 0; i < ret.length(); ++i) {
                if ('/' != ret.charAt(i) || ++count != 4) continue;
                slashPosition = i;
                break;
            }
            if (slashPosition > 0) {
                ret = ret.substring(0, slashPosition) + "...";
            } else if (ret.length() > 70) {
                ret = ret.substring(0, 70) + "...";
            }
        }
        return ret;
    }

    public String getFileTitle(Node fileNode) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)fileNode);
    }

    public String getFilePath(Node fileNode) throws Exception {
        return fileNode.getSession().getWorkspace().getName() + "@" + fileNode.getPath();
    }

    public String getBreadCrumbTitle(Object element) throws Exception {
        if (element instanceof DriveData) {
            return this.getDriveTitle((DriveData)element);
        }
        return this.breadCrumbTitle.get(this.breadCrumb.indexOf(element));
    }

    public String getFolderNodeIcon(Node node) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)node, (String)"uiIcon24x24");
    }

    public double getFileSize(Node node) throws Exception {
        Node contentNode;
        if (node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:data")) {
            return contentNode.getProperty("jcr:data").getLength();
        }
        return 0.0;
    }

    public String getFileTypeCSSClass(Node fileNode) throws Exception {
        String cssClass = CssClassUtils.getCSSClassByFileNameAndFileType((String)fileNode.getName(), (String)UIDocumentSelector.getFileMimeType(fileNode), (CssClassManager.ICON_SIZE)CssClassManager.ICON_SIZE.ICON_64).replace("uiIcon", "uiBgd");
        return cssClass;
    }

    public static String getFileMimeType(Node node) throws Exception {
        if (node.getPrimaryNodeType().getName().equals("nt:file") && node.hasNode("jcr:content")) {
            return node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        return "";
    }

    public boolean isFileSelected(Node fileNode) throws Exception {
        return this.breadCrumb.size() > 0 && this.breadCrumb.get(0) != null && StringUtils.equals((String)((DriveData)this.breadCrumb.get(0)).getWorkspace(), (String)fileNode.getSession().getWorkspace().getName()) && this.selectedFilePaths.contains(this.getFilePath(fileNode));
    }

    public List<Object> getBreadCrumb() {
        return this.breadCrumb;
    }

    public String getFolderTitle(Node folderNode) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)folderNode);
    }

    protected String getDriveHomePath(DriveData driveData) throws Exception {
        String homePath = driveData.getHomePath();
        if (homePath.contains(ALL_USER_PERMISSION)) {
            homePath = Utils.getPersonalDrivePath((String)homePath, (String)Util.getPortalRequestContext().getRemoteUser());
        }
        return homePath;
    }

    protected boolean hasPermissionOnDrive(DriveData drive) throws Exception {
        List userMemberships = org.exoplatform.ecm.webui.utils.Utils.getMemberships();
        String[] allPermission = drive.getAllPermissions();
        if (ALL_GROUP_PERMISSION.equals(allPermission[0]) || ALL_USER_PERMISSION.equals(allPermission[0])) {
            return true;
        }
        for (String membership : userMemberships) {
            if (!drive.hasPermission(allPermission, membership)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validateSelection() {
        this.validSelectedFilePaths.clear();
        this.validSelectedFilePaths.addAll(this.selectedFilePaths);
        this.selectedFilePaths.clear();
        this.selectedFileTitles.clear();
    }

    public boolean hasSelectedFiles() {
        return !this.selectedFilePaths.isEmpty();
    }

    @Override
    public Set<ComposerFileItem> getSelectFiles() {
        if (this.validSelectedFilePaths == null || this.validSelectedFilePaths.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ComposerFileItem> composerFileItems = new HashSet<ComposerFileItem>();
        for (String selectedFile : this.validSelectedFilePaths) {
            try {
                String selectedFileWS = selectedFile.substring(0, selectedFile.indexOf("@"));
                String selectedFilePath = selectedFile.substring(selectedFile.indexOf("@") + 1);
                Node node = this.getNode(selectedFileWS, selectedFilePath);
                ComposerFileItem composerFileItem = new ComposerFileItem();
                composerFileItem.setName(node.getName());
                composerFileItem.setMimeType(UIDocumentSelector.getFileMimeType(node));
                composerFileItem.setId(this.getFilePath(node));
                composerFileItem.setTitle(this.getFileTitle(node));
                double fileSize = this.getFileSize(node);
                String mbString = "MB";
                try {
                    ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
                    mbString = resourceBundle.getString("UIComposerDocumentExtension.label.megabyte");
                }
                catch (Exception resourceBundle) {
                    // empty catch block
                }
                String fileSizeMB = (double)((int)(Math.abs(fileSize / 1048576.0) * 100.0)) / 100.0 + " " + mbString;
                composerFileItem.setSizeInBytes(fileSize);
                composerFileItem.setSize(fileSizeMB);
                composerFileItem.setNodeIcon(this.getFileTypeCSSClass(node));
                composerFileItem.setResolverType(UPLOAD_RESOLVER_TYPE);
                composerFileItems.add(composerFileItem);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error occurred while proceeding selection of file " + selectedFile), (Throwable)e);
            }
        }
        return composerFileItems;
    }

    @Override
    public String getResolverType() {
        return UPLOAD_RESOLVER_TYPE;
    }

    @Override
    public Object preActivitySave(Object resource, UIComposer.PostContext postContext) throws Exception {
        ComposerFileItem fileItem = (ComposerFileItem)resource;
        String path = fileItem.getId();
        String selectedFileWS = path.substring(0, path.indexOf("@"));
        String selectedFilePath = path.substring(path.indexOf("@") + 1);
        return this.getNode(selectedFileWS, selectedFilePath);
    }

    @Override
    public void resetSelection() {
        this.breadCrumb.clear();
        this.breadCrumbTitle.clear();
        this.selectedFilePaths.clear();
        this.validSelectedFilePaths.clear();
        this.selectedFileTitles.clear();
    }

    @Override
    protected void removeSelectedFile(ComposerFileItem fileItem) {
    }

    public static class SelectActionListener
    extends EventListener<UIDocumentSelector> {
        /*
         * Enabled aggressive block sorting
         */
        public void execute(Event<UIDocumentSelector> event) throws Exception {
            UIDocumentSelector componentToUpdate;
            block25: {
                String selectedPath;
                String elementType;
                String selectionType;
                String[] params;
                String selectedElement;
                UIDocumentSelector component;
                block26: {
                    componentToUpdate = component = (UIDocumentSelector)((Object)event.getSource());
                    selectedElement = event.getRequestContext().getRequestParameter("objectId");
                    params = selectedElement.split(UIDocumentSelector.ACTIVITY_PARAMS_SEPARATOR);
                    if (params.length < 3) {
                        LOG.warn("Number of parameters must be 3 or greater (separated by /@/ ): {} ", new Object[]{selectedElement});
                        return;
                    }
                    selectionType = params[0];
                    elementType = params[1];
                    selectedPath = params[2];
                    if (!selectionType.equals("BREADCRUMB")) break block26;
                    if (StringUtils.isBlank((String)selectedPath)) {
                        LOG.warn("No entry was selected: {}", new Object[]{selectedElement});
                        return;
                    }
                    if (elementType.equals("DRIVES")) {
                        component.breadCrumb.clear();
                        component.breadCrumbTitle.clear();
                        break block25;
                    } else {
                        int breadCrumbIndex = Integer.parseInt(selectedPath);
                        if (elementType.equals("DRIVE")) {
                            if (breadCrumbIndex != 0) {
                                LOG.warn("Selected index isn't a drive: {} ", new Object[]{breadCrumbIndex});
                                return;
                            }
                            component.breadCrumb = component.getBreadCrumb().subList(0, 1);
                            component.breadCrumbTitle = component.breadCrumbTitle.subList(0, 1);
                            break block25;
                        } else {
                            if (!elementType.equals("FOLDER")) {
                                LOG.warn("Invalid breadcrumb element type: {} ", new Object[]{elementType});
                                return;
                            }
                            if (component.breadCrumb.size() < 2) {
                                LOG.warn("No folder was selected: {}", new Object[]{breadCrumbIndex});
                                return;
                            }
                            component.breadCrumb = component.breadCrumb.subList(0, breadCrumbIndex + 1);
                            component.breadCrumbTitle = component.breadCrumbTitle.subList(0, breadCrumbIndex + 1);
                        }
                    }
                    break block25;
                }
                if (!selectionType.equals("SELECTIONBOX")) {
                    LOG.warn("Invalid selection type: {} ", new Object[]{selectionType});
                    return;
                }
                if (elementType.equals("DRIVE")) {
                    if (component.getBreadCrumb().size() > 0) {
                        LOG.warn("Can't switch to another Drive while a drive is already selected: {} ", new Object[]{selectedPath});
                        return;
                    }
                    DriveData driveData = component.driveService.getDriveByName(selectedPath);
                    if (driveData != null && component.hasPermissionOnDrive(driveData)) {
                        component.breadCrumb.clear();
                        component.breadCrumbTitle.clear();
                        component.breadCrumb.add(driveData);
                        component.breadCrumbTitle.add(component.getDriveTitle(driveData));
                        break block25;
                    } else {
                        LOG.warn("Can't find drive with name {}", new Object[]{selectedPath});
                        return;
                    }
                }
                if (elementType.equals("FOLDER")) {
                    if (component.getBreadCrumb().size() == 0) {
                        LOG.warn("Can't find the selected drive for selected folder: {} ", new Object[]{selectedPath});
                        return;
                    }
                    DriveData driveData = (DriveData)component.getBreadCrumb().get(0);
                    component.breadCrumb.add(selectedPath);
                    component.breadCrumbTitle.add(component.getFolderTitle(component.getNode(driveData.getWorkspace(), selectedPath)));
                } else if (elementType.equals("FILE")) {
                    UIDocActivityPopup docActivityPopup = (UIDocActivityPopup)component.getAncestorOfType(UIDocActivityPopup.class);
                    componentToUpdate = component.getChild(UIDocumentSelectorUpdate.class);
                    if (params.length != 4) {
                        LOG.warn("Number of parameters must be equal to 4 (separated by /@/ ): {} ", new Object[]{selectedElement});
                        return;
                    }
                    String selectedFileTitle = params[3];
                    if (component.selectedFilePaths.contains(selectedPath)) {
                        component.selectedFilePaths.remove(selectedPath);
                        component.selectedFileTitles.remove(selectedFileTitle);
                        docActivityPopup.setLimitReached(component.selectedFilePaths.size() >= docActivityPopup.getMaxFilesCount());
                    } else {
                        component.lastSelectedDocumentTitle = selectedFileTitle;
                        if (component.selectedFileTitles.contains(selectedFileTitle)) {
                            component.documentAlreadySelectedError = true;
                        } else {
                            docActivityPopup.setLimitReached(component.selectedFilePaths.size() >= docActivityPopup.getMaxFilesCount());
                            if (!docActivityPopup.isLimitReached()) {
                                component.selectedFilePaths.add(selectedPath);
                                if (StringUtils.isNotBlank((String)selectedFileTitle)) {
                                    component.selectedFileTitles.add(selectedFileTitle);
                                }
                            }
                        }
                    }
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)componentToUpdate);
        }
    }
}

