/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ExpressionDecomposer;
import com.google.javascript.jscomp.FunctionArgumentInjector;
import com.google.javascript.jscomp.FunctionToBlockMutator;
import com.google.javascript.jscomp.InlineCostEstimator;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

class FunctionInjector {
    private final AbstractCompiler compiler;
    private final Supplier<String> safeNameIdSupplier;
    private final boolean allowDecomposition;
    private Set<String> knownConstants = Sets.newHashSet();
    private final boolean assumeStrictThis;
    private final boolean assumeMinimumCapture;
    private static final int NAME_COST_ESTIMATE = InlineCostEstimator.ESTIMATED_IDENTIFIER_COST;
    private static final int COMMA_COST = 1;
    private static final int PAREN_COST = 2;

    public FunctionInjector(AbstractCompiler compiler, Supplier<String> safeNameIdSupplier, boolean allowDecomposition, boolean assumeStrictThis, boolean assumeMinimumCapture) {
        Preconditions.checkNotNull((Object)compiler);
        Preconditions.checkNotNull(safeNameIdSupplier);
        this.compiler = compiler;
        this.safeNameIdSupplier = safeNameIdSupplier;
        this.allowDecomposition = allowDecomposition;
        this.assumeStrictThis = assumeStrictThis;
        this.assumeMinimumCapture = assumeMinimumCapture;
    }

    boolean doesFunctionMeetMinimumRequirements(final String fnName, Node fnNode) {
        Node block = NodeUtil.getFunctionBody(fnNode);
        if (!this.compiler.getCodingConvention().isInlinableFunction(fnNode)) {
            return false;
        }
        final String fnRecursionName = fnNode.getFirstChild().getString();
        Preconditions.checkState((fnRecursionName != null ? 1 : 0) != 0);
        boolean referencesArguments = NodeUtil.isNameReferenced(block, "arguments", NodeUtil.MATCH_NOT_FUNCTION);
        Predicate<Node> p = new Predicate<Node>(){

            public boolean apply(Node n) {
                if (n.isName()) {
                    return n.getString().equals("eval") || !fnName.isEmpty() && n.getString().equals(fnName) || !fnRecursionName.isEmpty() && n.getString().equals(fnRecursionName);
                }
                return false;
            }
        };
        return !referencesArguments && !NodeUtil.has(block, p, (Predicate<Node>)Predicates.alwaysTrue());
    }

    CanInlineResult canInlineReferenceToFunction(NodeTraversal t, Node callNode, Node fnNode, Set<String> needAliases, InliningMode mode, boolean referencesThis, boolean containsFunctions) {
        if (!this.isSupportedCallType(callNode)) {
            return CanInlineResult.NO;
        }
        if (containsFunctions) {
            if (!this.assumeMinimumCapture && !t.inGlobalScope()) {
                return CanInlineResult.NO;
            }
            if (NodeUtil.isWithinLoop(callNode)) {
                return CanInlineResult.NO;
            }
        }
        if (referencesThis && !NodeUtil.isFunctionObjectCall(callNode)) {
            return CanInlineResult.NO;
        }
        if (mode == InliningMode.DIRECT) {
            return this.canInlineReferenceDirectly(callNode, fnNode);
        }
        return this.canInlineReferenceAsStatementBlock(t, callNode, fnNode, needAliases);
    }

    private boolean isSupportedCallType(Node callNode) {
        Node thisValue;
        return callNode.getFirstChild().isName() || !(NodeUtil.isFunctionObjectCall(callNode) ? !this.assumeStrictThis && ((thisValue = callNode.getFirstChild().getNext()) == null || !thisValue.isThis()) : NodeUtil.isFunctionObjectApply(callNode));
    }

    Node inline(Node callNode, String fnName, Node fnNode, InliningMode mode) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        if (mode == InliningMode.DIRECT) {
            return this.inlineReturnValue(callNode, fnNode);
        }
        return this.inlineFunction(callNode, fnNode, fnName);
    }

    private Node inlineReturnValue(Node callNode, Node fnNode) {
        Node newExpression;
        Node block = fnNode.getLastChild();
        Node callParentNode = callNode.getParent();
        LinkedHashMap<String, Node> argMap = FunctionArgumentInjector.getFunctionCallParameterMap(fnNode, callNode, this.safeNameIdSupplier);
        if (!block.hasChildren()) {
            Node srcLocation = block;
            newExpression = NodeUtil.newUndefinedNode(srcLocation);
        } else {
            Node returnNode = block.getFirstChild();
            Preconditions.checkArgument((boolean)returnNode.isReturn());
            Node safeReturnNode = returnNode.cloneTree();
            Node inlineResult = FunctionArgumentInjector.inject(null, safeReturnNode, null, argMap);
            Preconditions.checkArgument((safeReturnNode == inlineResult ? 1 : 0) != 0);
            newExpression = safeReturnNode.removeFirstChild();
        }
        callParentNode.replaceChild(callNode, newExpression);
        return newExpression;
    }

    private CallSiteType classifyCallSite(Node callNode) {
        Node parent = callNode.getParent();
        Node grandParent = parent.getParent();
        if (NodeUtil.isExprCall(parent)) {
            return CallSiteType.SIMPLE_CALL;
        }
        if (NodeUtil.isExprAssign(grandParent) && !NodeUtil.isVarOrSimpleAssignLhs(callNode, parent) && parent.getFirstChild().isName() && !NodeUtil.isConstantName(parent.getFirstChild())) {
            return CallSiteType.SIMPLE_ASSIGNMENT;
        }
        if (parent.isName() && !NodeUtil.isConstantName(parent) && grandParent.isVar() && grandParent.hasOneChild()) {
            return CallSiteType.VAR_DECL_SIMPLE_ASSIGNMENT;
        }
        Node expressionRoot = ExpressionDecomposer.findExpressionRoot(callNode);
        if (expressionRoot != null) {
            ExpressionDecomposer decomposer = new ExpressionDecomposer(this.compiler, this.safeNameIdSupplier, this.knownConstants);
            ExpressionDecomposer.DecompositionType type = decomposer.canExposeExpression(callNode);
            if (type == ExpressionDecomposer.DecompositionType.MOVABLE) {
                return CallSiteType.EXPRESSION;
            }
            if (type == ExpressionDecomposer.DecompositionType.DECOMPOSABLE) {
                return CallSiteType.DECOMPOSABLE_EXPRESSION;
            }
            Preconditions.checkState((type == ExpressionDecomposer.DecompositionType.UNDECOMPOSABLE ? 1 : 0) != 0);
        }
        return CallSiteType.UNSUPPORTED;
    }

    private ExpressionDecomposer getDecomposer() {
        return new ExpressionDecomposer(this.compiler, this.safeNameIdSupplier, this.knownConstants);
    }

    void maybePrepareCall(Node callNode) {
        CallSiteType callSiteType = this.classifyCallSite(callNode);
        callSiteType.prepare(this, callNode);
    }

    private Node inlineFunction(Node callNode, Node fnNode, String fnName) {
        Node parent = callNode.getParent();
        Node grandParent = parent.getParent();
        CallSiteType callSiteType = this.classifyCallSite(callNode);
        Preconditions.checkArgument((callSiteType != CallSiteType.UNSUPPORTED ? 1 : 0) != 0);
        boolean isCallInLoop = NodeUtil.isWithinLoop(callNode);
        String resultName = null;
        boolean needsDefaultReturnResult = true;
        switch (callSiteType) {
            case SIMPLE_ASSIGNMENT: {
                resultName = parent.getFirstChild().getString();
                break;
            }
            case VAR_DECL_SIMPLE_ASSIGNMENT: {
                resultName = parent.getString();
                break;
            }
            case SIMPLE_CALL: {
                resultName = null;
                needsDefaultReturnResult = false;
                break;
            }
            case EXPRESSION: {
                throw new IllegalStateException("Movable expressions must be moved before inlining.");
            }
            case DECOMPOSABLE_EXPRESSION: {
                throw new IllegalStateException("Decomposable expressions must be decomposed before inlining.");
            }
            default: {
                throw new IllegalStateException("Unexpected call site type.");
            }
        }
        FunctionToBlockMutator mutator = new FunctionToBlockMutator(this.compiler, this.safeNameIdSupplier);
        Node newBlock = mutator.mutate(fnName, fnNode, callNode, resultName, needsDefaultReturnResult, isCallInLoop);
        Node greatGrandParent = grandParent.getParent();
        switch (callSiteType) {
            case VAR_DECL_SIMPLE_ASSIGNMENT: {
                parent.removeChild(parent.getFirstChild());
                Preconditions.checkState((parent.getFirstChild() == null ? 1 : 0) != 0);
                greatGrandParent.addChildAfter(newBlock, grandParent);
                break;
            }
            case SIMPLE_ASSIGNMENT: {
                Preconditions.checkState((boolean)grandParent.isExprResult());
                greatGrandParent.replaceChild(grandParent, newBlock);
                break;
            }
            case SIMPLE_CALL: {
                Preconditions.checkState((boolean)parent.isExprResult());
                grandParent.replaceChild(parent, newBlock);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected call site type.");
            }
        }
        return newBlock;
    }

    boolean isDirectCallNodeReplacementPossible(Node fnNode) {
        Node block = NodeUtil.getFunctionBody(fnNode);
        if (!block.hasChildren()) {
            return true;
        }
        return block.hasOneChild() && block.getFirstChild().isReturn() && block.getFirstChild().getFirstChild() != null;
    }

    private CanInlineResult canInlineReferenceAsStatementBlock(NodeTraversal t, Node callNode, Node fnNode, Set<String> namesToAlias) {
        CallSiteType callSiteType = this.classifyCallSite(callNode);
        if (callSiteType == CallSiteType.UNSUPPORTED) {
            return CanInlineResult.NO;
        }
        if (!(this.allowDecomposition || callSiteType != CallSiteType.DECOMPOSABLE_EXPRESSION && callSiteType != CallSiteType.EXPRESSION)) {
            return CanInlineResult.NO;
        }
        if (!this.callMeetsBlockInliningRequirements(t, callNode, fnNode, namesToAlias)) {
            return CanInlineResult.NO;
        }
        if (callSiteType == CallSiteType.DECOMPOSABLE_EXPRESSION || callSiteType == CallSiteType.EXPRESSION) {
            return CanInlineResult.AFTER_PREPARATION;
        }
        return CanInlineResult.YES;
    }

    private boolean callMeetsBlockInliningRequirements(NodeTraversal t, Node callNode, final Node fnNode, Set<String> namesToAlias) {
        final boolean assumeMinimumCapture = this.assumeMinimumCapture;
        boolean fnContainsVars = NodeUtil.has(NodeUtil.getFunctionBody(fnNode), new NodeUtil.MatchDeclaration(), new NodeUtil.MatchShallowStatement());
        boolean forbidTemps = false;
        if (!t.inGlobalScope()) {
            Node fnCaller = t.getScopeRoot();
            Node fnCallerBody = fnCaller.getLastChild();
            Predicate<Node> match = new Predicate<Node>(){

                public boolean apply(Node n) {
                    if (n.isName()) {
                        return n.getString().equals("eval");
                    }
                    if (!assumeMinimumCapture && n.isFunction()) {
                        return n != fnNode;
                    }
                    return false;
                }
            };
            forbidTemps = NodeUtil.has(fnCallerBody, match, NodeUtil.MATCH_NOT_FUNCTION);
        }
        if (fnContainsVars && forbidTemps) {
            return false;
        }
        if (forbidTemps) {
            boolean hasArgs;
            LinkedHashMap<String, Node> args = FunctionArgumentInjector.getFunctionCallParameterMap(fnNode, callNode, this.safeNameIdSupplier);
            boolean bl = hasArgs = !args.isEmpty();
            if (hasArgs) {
                HashSet allNamesToAlias = Sets.newHashSet(namesToAlias);
                FunctionArgumentInjector.maybeAddTempsForCallArguments(fnNode, args, allNamesToAlias, this.compiler.getCodingConvention());
                if (!allNamesToAlias.isEmpty()) {
                    return false;
                }
            }
        }
        return true;
    }

    private CanInlineResult canInlineReferenceDirectly(Node callNode, Node fnNode) {
        if (!this.isDirectCallNodeReplacementPossible(fnNode)) {
            return CanInlineResult.NO;
        }
        Node block = fnNode.getLastChild();
        Node cArg = callNode.getFirstChild().getNext();
        if (!callNode.getFirstChild().isName()) {
            if (NodeUtil.isFunctionObjectCall(callNode)) {
                if (cArg == null || !cArg.isThis()) {
                    return CanInlineResult.NO;
                }
                cArg = cArg.getNext();
            } else {
                Preconditions.checkState((!NodeUtil.isFunctionObjectApply(callNode) ? 1 : 0) != 0);
            }
        }
        Node fnParam = NodeUtil.getFunctionParameters(fnNode).getFirstChild();
        while (cArg != null || fnParam != null) {
            if (fnParam != null) {
                if (cArg != null && NodeUtil.mayEffectMutableState(cArg, this.compiler) && NodeUtil.getNameReferenceCount(block, fnParam.getString()) > 1) {
                    return CanInlineResult.NO;
                }
                fnParam = fnParam.getNext();
            }
            if (cArg == null) continue;
            if (NodeUtil.mayHaveSideEffects(cArg, this.compiler)) {
                return CanInlineResult.NO;
            }
            cArg = cArg.getNext();
        }
        return CanInlineResult.YES;
    }

    boolean inliningLowersCost(JSModule fnModule, Node fnNode, Collection<? extends Reference> refs, Set<String> namesToAlias, boolean isRemovable, boolean referencesThis) {
        int referenceCount = refs.size();
        if (referenceCount == 0) {
            return true;
        }
        int referencesUsingBlockInlining = 0;
        boolean checkModules = isRemovable && fnModule != null;
        JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
        for (Reference reference : refs) {
            if (reference.mode == InliningMode.BLOCK) {
                ++referencesUsingBlockInlining;
            }
            if (!checkModules || reference.module == null || reference.module == fnModule || moduleGraph.dependsOn(reference.module, fnModule)) continue;
            isRemovable = false;
            checkModules = false;
        }
        int referencesUsingDirectInlining = referenceCount - referencesUsingBlockInlining;
        if (referenceCount == 1 && isRemovable && referencesUsingDirectInlining == 1) {
            return true;
        }
        int n = FunctionInjector.estimateCallCost(fnNode, referencesThis);
        int overallCallCost = n * referenceCount;
        int costDeltaDirect = FunctionInjector.inlineCostDelta(fnNode, namesToAlias, InliningMode.DIRECT);
        int costDeltaBlock = FunctionInjector.inlineCostDelta(fnNode, namesToAlias, InliningMode.BLOCK);
        return this.doesLowerCost(fnNode, overallCallCost, referencesUsingDirectInlining, costDeltaDirect, referencesUsingBlockInlining, costDeltaBlock, isRemovable);
    }

    private boolean doesLowerCost(Node fnNode, int callCost, int directInlines, int costDeltaDirect, int blockInlines, int costDeltaBlock, boolean removable) {
        int fnInstanceCount = directInlines + blockInlines - (removable ? 1 : 0);
        if (fnInstanceCount == 0) {
            return blockInlines <= 0 || costDeltaBlock <= 0;
        }
        int costDelta = directInlines * costDeltaDirect + blockInlines * costDeltaBlock;
        int threshold = (callCost - costDelta) / fnInstanceCount;
        return InlineCostEstimator.getCost(fnNode, threshold + 1) <= threshold;
    }

    private static int estimateCallCost(Node fnNode, boolean referencesThis) {
        Node argsNode = NodeUtil.getFunctionParameters(fnNode);
        int numArgs = argsNode.getChildCount();
        int callCost = NAME_COST_ESTIMATE + 2;
        if (numArgs > 0) {
            callCost += numArgs * NAME_COST_ESTIMATE + (numArgs - 1) * 1;
        }
        if (referencesThis) {
            callCost += 10;
        }
        return callCost;
    }

    private static int inlineCostDelta(Node fnNode, Set<String> namesToAlias, InliningMode mode) {
        int paramCount = NodeUtil.getFunctionParameters(fnNode).getChildCount();
        int commaCount = paramCount > 1 ? paramCount - 1 : 0;
        int costDeltaFunctionOverhead = 15 + commaCount + paramCount * InlineCostEstimator.ESTIMATED_IDENTIFIER_COST;
        Node block = fnNode.getLastChild();
        if (!block.hasChildren()) {
            return -costDeltaFunctionOverhead;
        }
        if (mode == InliningMode.DIRECT) {
            return -(costDeltaFunctionOverhead + 7);
        }
        int aliasCount = namesToAlias.size();
        int inlineBlockOverhead = 4;
        int perReturnOverhead = 2;
        int perReturnResultOverhead = 3;
        int perAliasOverhead = 3;
        int returnCount = NodeUtil.getNodeTypeReferenceCount(block, 4, new NodeUtil.MatchShallowStatement());
        int resultCount = returnCount > 0 ? returnCount - 1 : 0;
        int baseOverhead = returnCount > 0 ? 4 : 0;
        int overhead = baseOverhead + returnCount * 2 + resultCount * 3 + aliasCount * 3;
        return overhead - costDeltaFunctionOverhead;
    }

    public void setKnownConstants(Set<String> knownConstants) {
        Preconditions.checkState((boolean)this.knownConstants.isEmpty());
        this.knownConstants = knownConstants;
    }

    static enum CanInlineResult {
        YES,
        AFTER_PREPARATION,
        NO;

    }

    private static enum CallSiteType {
        UNSUPPORTED{

            @Override
            public void prepare(FunctionInjector injector, Node callNode) {
                throw new IllegalStateException("unexpected");
            }
        }
        ,
        SIMPLE_CALL{

            @Override
            public void prepare(FunctionInjector injector, Node callNode) {
            }
        }
        ,
        SIMPLE_ASSIGNMENT{

            @Override
            public void prepare(FunctionInjector injector, Node callNode) {
            }
        }
        ,
        VAR_DECL_SIMPLE_ASSIGNMENT{

            @Override
            public void prepare(FunctionInjector injector, Node callNode) {
            }
        }
        ,
        EXPRESSION{

            @Override
            public void prepare(FunctionInjector injector, Node callNode) {
                injector.getDecomposer().moveExpression(callNode);
                CallSiteType callSiteType = injector.classifyCallSite(callNode);
                Preconditions.checkState((this != callSiteType ? 1 : 0) != 0);
                callSiteType.prepare(injector, callNode);
            }
        }
        ,
        DECOMPOSABLE_EXPRESSION{

            @Override
            public void prepare(FunctionInjector injector, Node callNode) {
                injector.getDecomposer().maybeExposeExpression(callNode);
                CallSiteType callSiteType = injector.classifyCallSite(callNode);
                Preconditions.checkState((this != callSiteType ? 1 : 0) != 0);
                callSiteType.prepare(injector, callNode);
            }
        };


        public abstract void prepare(FunctionInjector var1, Node var2);
    }

    static class Reference {
        final Node callNode;
        final JSModule module;
        final InliningMode mode;

        Reference(Node callNode, JSModule module, InliningMode mode) {
            this.callNode = callNode;
            this.module = module;
            this.mode = mode;
        }
    }

    static enum InliningMode {
        DIRECT,
        BLOCK;

    }
}

