/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.social.core.jpa.storage.entity.ActivityEntity;
import org.exoplatform.social.core.jpa.storage.entity.StreamType;

@Entity(name="SocStreamItem")
@ExoEntity
@Table(name="SOC_STREAM_ITEMS")
@NamedQueries(value={@NamedQuery(name="SocStreamItem.migrateOwner", query="UPDATE SocStreamItem s SET s.ownerId = :newId WHERE s.ownerId = :oldId"), @NamedQuery(name="getStreamByActivityId", query="select s from SocStreamItem s join s.activity A where A.id = :activityId")})
public class StreamItemEntity {
    @Id
    @SequenceGenerator(name="SEQ_SOC_STREAM_ITEMS_ID", sequenceName="SEQ_SOC_STREAM_ITEMS_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_STREAM_ITEMS_ID")
    @Column(name="STREAM_ITEM_ID")
    private Long id;
    @ManyToOne
    @JoinColumn(name="ACTIVITY_ID", nullable=false)
    private ActivityEntity activity;
    @Column(name="ACTIVITY_ID", insertable=false, updatable=false)
    private Long activityId;
    @Column(name="OWNER_ID", nullable=false)
    private Long ownerId;
    @Column(name="UPDATED_DATE", nullable=false)
    private Long updatedDate;
    @Enumerated
    @Column(name="STREAM_TYPE", nullable=false)
    private StreamType streamType;

    public StreamItemEntity() {
    }

    public StreamItemEntity(StreamType streamType) {
        this.streamType = streamType;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ActivityEntity getActivity() {
        return this.activity;
    }

    public void setActivity(ActivityEntity activity) {
        this.activity = activity;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public StreamType getStreamType() {
        return this.streamType;
    }

    public void setStreamType(StreamType streamType) {
        this.streamType = streamType;
    }

    public Date getUpdatedDate() {
        return this.updatedDate != null && this.updatedDate > 0L ? new Date(this.updatedDate) : null;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate != null ? updatedDate.getTime() : 0L;
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }
}

