/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.installer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Properties;
import org.gatein.portal.installer.PortalSetupService;

public class PortalSetupCommand {
    public static final String HELP_OPTION = "-h";
    public static final String PASSWORD_OPTION = "-p";
    public static final String PROPERTIES_FILE_OPTION = "-f";
    public static final String PROPERTIES_STANDARD_ENCODING = "iso-8859-1";
    public static final String SCRIPT_NAME = "portal-setup";
    private String password;
    private File propertiesFile;

    private static boolean containsRootPasswordProperty(String line) {
        int offset;
        block6: for (offset = 0; offset < line.length(); ++offset) {
            switch (line.charAt(offset)) {
                case '\t': 
                case '\f': 
                case ' ': {
                    continue block6;
                }
            }
        }
        String propName = "gatein.portal.setup.initialpassword.root";
        for (int i = 0; i < propName.length(); ++i) {
            if (offset < line.length() && propName.charAt(i) == line.charAt(offset++)) continue;
            return false;
        }
        if (offset == line.length()) {
            return true;
        }
        switch (line.charAt(offset)) {
            case '\t': 
            case '\f': 
            case ' ': 
            case ':': 
            case '=': {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        PortalSetupCommand cmd = new PortalSetupCommand();
        try {
            cmd.parseArgs(args);
            cmd.validate();
            cmd.process();
        }
        catch (SetupCommandException e) {
            cmd.usage(e);
        }
    }

    public void parseArgs(String[] args) throws SetupCommandException {
        if (args != null) {
            if (args.length < 2) {
                throw new SetupCommandException("Missing parameter -f.");
            }
            int i = 0;
            while (i < args.length) {
                String arg;
                if (PASSWORD_OPTION.equals(arg = args[i++])) {
                    if (i >= args.length) {
                        throw new SetupCommandException("Password expected after -p.");
                    }
                    this.password = args[i++];
                    continue;
                }
                if (PROPERTIES_FILE_OPTION.equals(arg)) {
                    if (i >= args.length) {
                        throw new SetupCommandException("Properties file path expected after -f.");
                    }
                    this.propertiesFile = new File(args[i++]);
                    continue;
                }
                if (HELP_OPTION.equals(arg)) {
                    throw new SetupCommandException("");
                }
                throw new SetupCommandException("Unrecognized parameter '" + arg + "'.");
            }
        }
    }

    public void process() throws SetupCommandException {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.propertiesFile);
            props.load(in);
        }
        catch (FileNotFoundException e) {
            throw new SetupCommandException("File does not exist: '" + this.propertiesFile.getAbsolutePath() + "'", e);
        }
        catch (IOException e) {
            throw new SetupCommandException(e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (props.containsKey("gatein.portal.setup.initialpassword.root")) {
            BufferedReader r = null;
            FileOutputStream out = null;
            BufferedWriter w = null;
            File propertiesFileBackup = new File(this.propertiesFile + ".backup");
            try {
                this.propertiesFile.renameTo(propertiesFileBackup);
                in = new FileInputStream(propertiesFileBackup);
                r = new BufferedReader(new InputStreamReader((InputStream)in, PROPERTIES_STANDARD_ENCODING));
                out = new FileOutputStream(this.propertiesFile);
                w = new BufferedWriter(new OutputStreamWriter((OutputStream)out, PROPERTIES_STANDARD_ENCODING));
                String line = null;
                while ((line = r.readLine()) != null) {
                    if (PortalSetupCommand.containsRootPasswordProperty(line)) {
                        this.writeRootPasswordLine(w);
                        continue;
                    }
                    w.write(line);
                    w.write(10);
                }
            }
            catch (FileNotFoundException e) {
                throw new SetupCommandException("File does not exist: '" + this.propertiesFile.getAbsolutePath() + "'", e);
            }
            catch (UnsupportedEncodingException e) {
                throw new SetupCommandException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new SetupCommandException(e.getMessage(), e);
            }
            finally {
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (IOException e) {
                        throw new SetupCommandException(e.getMessage(), e);
                    }
                }
                if (r != null) {
                    try {
                        r.close();
                        propertiesFileBackup.delete();
                    }
                    catch (IOException e) {
                        throw new SetupCommandException(e.getMessage(), e);
                    }
                }
            }
        }
        FileOutputStream out = null;
        Writer w = null;
        try {
            out = new FileOutputStream(this.propertiesFile, true);
            w = new OutputStreamWriter((OutputStream)out, PROPERTIES_STANDARD_ENCODING);
            this.writeRootPasswordLine(w);
        }
        catch (FileNotFoundException e) {
            throw new SetupCommandException("File does not exist: '" + this.propertiesFile.getAbsolutePath() + "'", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SetupCommandException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SetupCommandException(e.getMessage(), e);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {
                    throw new SetupCommandException(e.getMessage(), e);
                }
            }
        }
    }

    private void writeRootPasswordLine(Writer w) throws SetupCommandException, IOException {
        try {
            String encodedPassword = PortalSetupService.encodePassword(this.password);
            w.write("gatein.portal.setup.initialpassword.root");
            w.write(61);
            w.write(encodedPassword);
            w.write(" # Modified by ");
            w.write(SCRIPT_NAME);
            w.write(".sh\n");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SetupCommandException(e.getMessage(), e);
        }
        catch (InvalidKeySpecException e) {
            throw new SetupCommandException(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SetupCommandException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SetupCommandException(e.getMessage(), e);
        }
    }

    public void usage(Throwable error) {
        String msg;
        if (error != null && (msg = error.getMessage()) != null && msg.length() > 0) {
            System.err.println("Error: " + msg);
        }
        System.err.println("================================================================================");
        System.err.println("portal-setup[ .sh | .bat ] - a utility for setting an initial password for");
        System.err.println("                portal user 'root'.");
        System.err.println();
        System.err.println("Usage: portal-setup[ .sh | .bat ] [ -f <path> ] [ -p <password> ] [ -h ]");
        System.err.println();
        System.err.println("    -f <path> - path to portal properties file. If not set explicitly,");
        System.err.println("                the default path for the given platform will be used.");
        System.err.println();
        System.err.println("    -p <password> - the password that will be appended to properties file given");
        System.err.println("                in -f.");
        System.err.println();
        System.err.println("    -h - Print these usage instructions and exit.");
        System.err.println();
    }

    public void validate() throws SetupCommandException {
        if (this.propertiesFile == null) {
            throw new SetupCommandException("Missing parameter -f.");
        }
        if (!this.propertiesFile.exists()) {
            throw new SetupCommandException("File does not exist: '" + this.propertiesFile.getAbsolutePath() + "'");
        }
        if (this.password == null) {
            System.out.print("Set root password: ");
            this.password = new String(System.console().readPassword());
            System.out.print("Repeat root password: ");
            String password2 = new String(System.console().readPassword());
            if (!this.password.equals(password2)) {
                throw new SetupCommandException("Passwords are not equal.");
            }
        }
    }

    public static class SetupCommandException
    extends Exception {
        private static final long serialVersionUID = 2766753482448227104L;

        public SetupCommandException(String message) {
            super(message);
        }

        public SetupCommandException(String message, Throwable cause) {
            super(message, cause);
        }

        public SetupCommandException(Throwable cause) {
            super(cause);
        }
    }
}

