/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.mail.Message;

public class MessageBuilder {
    public static final String CONTEN_EMAIL = Utils.DEFAULT_EMAIL_CONTENT;
    public static final String SLASH = "/".intern();
    public static final String TOPIC_DELIMITER = "/topic/".intern();
    public static final String EMPTY_STRING = "".intern();
    private String id;
    private String owner;
    private String headerSubject;
    private String content = CONTEN_EMAIL;
    private String objName;
    private String watchType;
    private String addType;
    private String addName;
    private String message;
    private String catName;
    private String forumName;
    private String topicName;
    private String link;
    private String privateLink;
    private String dateFormat = "MM/dd/yyyy";
    private String timeFormat = "HH:mm";
    private String zoneTime = "GMT+0";
    private Date createdDate;
    private Map<String, String> types = new HashMap<String, String>();

    public MessageBuilder() {
        this.types.put(Utils.CATEGORY, "Category");
        this.types.put(Utils.FORUM, Utils.FORUM);
        this.types.put(Utils.TOPIC, Utils.TOPIC);
        this.types.put(Utils.POST, Utils.POST);
        this.link = "";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getHeaderSubject() {
        return this.headerSubject;
    }

    public void setHeaderSubject(String headerSubject) {
        this.headerSubject = headerSubject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public String getWatchType() {
        return this.watchType;
    }

    public void setWatchType(String watchType) {
        this.watchType = watchType;
    }

    public String getAddType() {
        return this.addType;
    }

    public void setAddType(String addType) {
        this.addType = addType;
    }

    public String getAddName() {
        return this.addName;
    }

    public void setAddName(String addName) {
        this.addName = addName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCatName() {
        return this.catName;
    }

    public void setCatName(String catName) {
        this.catName = catName;
    }

    public String getForumName() {
        return this.forumName;
    }

    public void setForumName(String forumName) {
        this.forumName = forumName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getZoneTime() {
        return this.zoneTime;
    }

    public void setZoneTime(String zoneTime) {
        this.zoneTime = zoneTime;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Map<String, String> getTypes() {
        return this.types;
    }

    public void setTypes(String cate, String forum, String topic, String post) {
        this.types = new HashMap<String, String>();
        this.types.put(Utils.CATEGORY, cate);
        this.types.put(Utils.FORUM, forum);
        this.types.put(Utils.TOPIC, topic);
        this.types.put(Utils.POST, post);
    }

    public void makePrivateLink() {
        try {
            if (!CommonUtils.isEmpty((String)this.link)) {
                String host = CommonsUtils.getCurrentDomain();
                if (this.link.indexOf("http") == 0) {
                    host = this.link.substring(0, this.link.indexOf(SLASH, 8));
                } else {
                    this.link = host + this.link;
                }
                String subLink = CommonUtils.getURI((String)this.link);
                String ptContainer = subLink.substring(1, subLink.indexOf(SLASH, 2));
                String topicId = this.link.substring(this.link.lastIndexOf(TOPIC_DELIMITER)).replace(TOPIC_DELIMITER, EMPTY_STRING).replaceAll(SLASH, EMPTY_STRING);
                if (topicId.replaceFirst(Utils.TOPIC, Utils.POST).equals(this.id)) {
                    subLink = subLink + SLASH + this.id;
                }
                this.privateLink = host + SLASH + ptContainer + SLASH + "login?initialURI=" + subLink;
            }
        }
        catch (Exception e) {
            this.privateLink = this.link;
        }
    }

    public Message getContentEmail() {
        this.makePrivateLink();
        this.buildHeaderSubject();
        Message message = new Message();
        message.setMimeType("text/html");
        message.setFrom(this.owner);
        message.setSubject(StringCommonUtils.decodeSpecialCharToHTMLnumber((String)this.headerSubject));
        String content_ = StringUtils.replace((String)this.content, (String)"$OBJECT_NAME", (String)this.objName);
        content_ = StringUtils.replace((String)content_, (String)"$OBJECT_WATCH_TYPE", (String)this.types.get(this.watchType));
        content_ = StringUtils.replace((String)content_, (String)"$ADD_TYPE", (String)this.types.get(this.addType));
        content_ = StringUtils.replace((String)content_, (String)"$ADD_NAME", (String)this.addName);
        content_ = StringUtils.replace((String)content_, (String)"$POST_CONTENT", (String)this.message);
        SimpleDateFormat formatter = new SimpleDateFormat(this.timeFormat);
        content_ = StringUtils.replace((String)content_, (String)"$TIME", (String)(formatter.format((Object)this.createdDate) + " " + this.zoneTime));
        formatter = new SimpleDateFormat(this.dateFormat);
        content_ = StringUtils.replace((String)content_, (String)"$DATE", (String)formatter.format((Object)this.createdDate));
        content_ = StringUtils.replace((String)content_, (String)"$POSTER", (String)this.owner);
        content_ = StringUtils.replace((String)content_, (String)"$VIEWPOST_LINK", (String)this.link);
        content_ = StringUtils.replace((String)content_, (String)"$VIEWPOST_PRIVATE_LINK", (String)this.privateLink);
        content_ = StringUtils.replace((String)content_, (String)"$REPLYPOST_LINK", (String)(this.privateLink + "/true"));
        content_ = StringUtils.replace((String)content_, (String)"$CATEGORY", (String)this.catName);
        content_ = StringUtils.replace((String)content_, (String)"$FORUM", (String)this.forumName);
        content_ = StringUtils.replace((String)content_, (String)"$TOPIC", (String)this.topicName);
        message.setBody(CommonUtils.convertCodeHTML((String)content_));
        return message;
    }

    private void buildHeaderSubject() {
        if (this.headerSubject != null && this.headerSubject.length() > 0) {
            this.headerSubject = StringUtils.replace((String)this.headerSubject, (String)"$CATEGORY", (String)this.catName);
            this.headerSubject = StringUtils.replace((String)this.headerSubject, (String)"$FORUM", (String)this.forumName);
            this.headerSubject = StringUtils.replace((String)this.headerSubject, (String)"$TOPIC", (String)this.topicName);
        } else {
            this.headerSubject = "[" + this.catName + "][" + this.forumName + "] " + (Utils.isEmpty(this.topicName) ? this.objName : this.topicName);
        }
    }

    public Message getContentEmailMoved() {
        this.makePrivateLink();
        this.buildHeaderSubject();
        Message message = new Message();
        message.setMimeType("text/html");
        message.setFrom(this.owner);
        message.setSubject(StringCommonUtils.decodeSpecialCharToHTMLnumber((String)this.headerSubject));
        String content_ = StringUtils.replace((String)this.content, (String)"$OBJECT_NAME", (String)this.objName);
        content_ = StringUtils.replace((String)content_, (String)"$OBJECT_PARENT_NAME", (String)this.addType);
        content_ = StringUtils.replace((String)content_, (String)"$POSTER", (String)this.owner);
        content_ = StringUtils.replace((String)content_, (String)"$VIEWPOST_LINK", (String)this.link);
        content_ = StringUtils.replace((String)content_, (String)"$VIEWPOST_PRIVATE_LINK", (String)this.privateLink);
        content_ = StringUtils.replace((String)content_, (String)"$REPLYPOST_LINK", (String)(this.privateLink + "/true"));
        content_ = StringUtils.replace((String)content_, (String)"$OBJECT_PARENT_TYPE", (String)this.types.get(Utils.CATEGORY));
        content_ = StringUtils.replace((String)content_, (String)"$OBJECT_TYPE", (String)this.types.get(Utils.FORUM));
        message.setBody(CommonUtils.convertCodeHTML((String)content_));
        return message;
    }
}

