/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import javax.jcr.Node;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;

public class ForumMembershipEventListener
extends MembershipEventListener {
    private Log LOG = ExoLogger.getLogger(ForumMembershipEventListener.class);
    public static final String PLATFORM_ADMIN_GROUP = "/platform/administrators";

    public void preSave(Membership m, boolean isNew) throws Exception {
        ForumServiceUtils.clearCache();
    }

    public void preDelete(Membership m) throws Exception {
        ForumServiceUtils.clearCache();
    }

    public void postSave(Membership m, boolean isNew) throws Exception {
        if (PLATFORM_ADMIN_GROUP.equals(m.getGroupId())) {
            try {
                KSDataLocation dataLocation = (KSDataLocation)CommonsUtils.getService(KSDataLocation.class);
                Node rootNode = dataLocation.getSessionManager().openSession().getRootNode();
                if (rootNode.hasNode(dataLocation.getUserProfilesLocation() + "/" + m.getUserName())) {
                    Node userProfileNode = rootNode.getNode(dataLocation.getUserProfilesLocation()).getNode(m.getUserName());
                    userProfileNode.setProperty("exo:userRole", 0L);
                    userProfileNode.save();
                }
            }
            catch (Exception e) {
                this.LOG.error((Object)("Failed to update user role : " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

