/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bbcode.core.cache.data;

import java.util.Objects;
import org.exoplatform.forum.bbcode.api.BBCode;
import org.exoplatform.forum.common.cache.model.CachedData;

public class BBCodeCacheData
implements CachedData<BBCode> {
    private static final long serialVersionUID = 1L;
    public static final BBCodeCacheData NULL = new BBCodeCacheData(new BBCode());
    private final String id;
    private final String tagName;
    private final String replacement;
    private final String description;
    private final String example;
    private final boolean isActive;
    private final boolean isOption;

    public BBCodeCacheData(BBCode bbCode) {
        this.id = bbCode.getId();
        this.tagName = bbCode.getTagName();
        this.replacement = bbCode.getReplacement();
        this.description = bbCode.getDescription();
        this.example = bbCode.getExample();
        this.isActive = bbCode.isActive();
        this.isOption = bbCode.isOption();
    }

    public BBCode build() {
        if (this == NULL) {
            return null;
        }
        BBCode bbCode = new BBCode();
        bbCode.setId(this.id);
        bbCode.setTagName(this.tagName);
        bbCode.setReplacement(this.replacement);
        bbCode.setDescription(this.description);
        bbCode.setExample(this.example);
        bbCode.setOption(this.isOption);
        bbCode.setActive(this.isActive);
        return bbCode;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BBCodeCacheData that = (BBCodeCacheData)o;
        return this.isActive == that.isActive && this.isOption == that.isOption && Objects.equals(this.id, that.id) && Objects.equals(this.tagName, that.tagName) && Objects.equals(this.replacement, that.replacement) && Objects.equals(this.description, that.description) && Objects.equals(this.example, that.example);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tagName, this.replacement, this.description, this.example, this.isActive, this.isOption);
    }
}

