/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.management.operations.page.PageUtils;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.application.UIGadget;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPageActionListener {

    public static class RemoveChildActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)((Object)event.getSource());
            String id = event.getRequestContext().getRequestParameter("objectId");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            if (uiPage.isModifiable()) {
                uiPage.removeChildById(id);
                Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                PageService pageService = (PageService)uiPage.getApplicationComponent(PageService.class);
                PageState pageState = PageUtils.toPageState((Page)page);
                pageService.savePage(new PageContext(page.getPageKey(), pageState));
                DataStorage dataService = (DataStorage)uiPage.getApplicationComponent(DataStorage.class);
                dataService.save(page);
                pcontext.ignoreAJAXUpdateOnPortlets(false);
                pcontext.setResponseComplete(true);
                pcontext.getWriter().write("OK");
            } else {
                UIApplication uiApp = pcontext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPage.msg.EditPermission.null", null));
            }
        }
    }

    public static class DeleteGadgetActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            WebuiRequestContext pContext = event.getRequestContext();
            String id = pContext.getRequestParameter("objectId");
            UIPage uiPage = (UIPage)((Object)event.getSource());
            ArrayList uiWidgets = new ArrayList();
            uiPage.findComponentOfType(uiWidgets, UIGadget.class);
            for (UIGadget uiWidget : uiWidgets) {
                if (!uiWidget.getId().equals(id)) continue;
                uiPage.getChildren().remove((Object)uiWidget);
                String userName = pContext.getRemoteUser();
                if (userName == null || userName.trim().length() > 0) {
                    // empty if block
                }
                if (!uiPage.isModifiable()) break;
                Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                PageService pageService = (PageService)uiPage.getApplicationComponent(PageService.class);
                PageState pageState = PageUtils.toPageState((Page)page);
                pageService.savePage(new PageContext(page.getPageKey(), pageState));
                DataStorage dataService = (DataStorage)uiPage.getApplicationComponent(DataStorage.class);
                dataService.save(page);
                break;
            }
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            pcontext.ignoreAJAXUpdateOnPortlets(false);
            pcontext.setResponseComplete(true);
            pcontext.getWriter().write("OK");
        }
    }

    public static class ChangeNodeActionListener
    extends EventListener<UIPortalApplication> {
        public void execute(Event<UIPortalApplication> event) throws Exception {
            PortalRequestContext pcontext = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
            UserPortal userPortal = pcontext.getUserPortalConfig().getUserPortal();
            UIPortalApplication uiPortalApp = (UIPortalApplication)((Object)event.getSource());
            UIPortal showedUIPortal = uiPortalApp.getCurrentSite();
            UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
            builder.withReadCheck();
            PageNodeEvent pageNodeEvent = (PageNodeEvent)event;
            String nodePath = pageNodeEvent.getTargetNodeUri();
            UserNode targetNode = null;
            SiteKey siteKey = pageNodeEvent.getSiteKey();
            if (siteKey != null) {
                NavigationService service;
                NavigationContext navContext;
                if (pcontext.getRemoteUser() == null && (siteKey.getType().equals((Object)SiteType.GROUP) || siteKey.getType().equals((Object)SiteType.USER)) && (navContext = (service = (NavigationService)uiPortalApp.getApplicationComponent(NavigationService.class)).loadNavigation(siteKey)) != null) {
                    uiPortalApp.setLastRequestNavData(null);
                    pcontext.requestAuthenticationLogin();
                    return;
                }
                UserNavigation navigation = userPortal.getNavigation(siteKey);
                if (navigation != null && (targetNode = userPortal.resolvePath(navigation, builder.build(), nodePath)) == null) {
                    if (pcontext.getRemoteUser() == null && siteKey.getType().equals((Object)SiteType.PORTAL)) {
                        targetNode = userPortal.resolvePath(navigation, null, nodePath);
                        if (targetNode != null) {
                            uiPortalApp.setLastRequestNavData(null);
                            pcontext.requestAuthenticationLogin();
                            return;
                        }
                    } else {
                        targetNode = userPortal.getDefaultPath(navigation, builder.build());
                    }
                }
            }
            if (targetNode == null && (targetNode = userPortal.getDefaultPath(builder.build())) == null) {
                if (showedUIPortal != null) {
                    UIPageBody uiPageBody = (UIPageBody)showedUIPortal.findFirstComponentOfType(UIPageBody.class);
                    uiPageBody.setUIComponent(null);
                }
                return;
            }
            UserNavigation targetNav = targetNode.getNavigation();
            UserNode currentNavPath = null;
            if (showedUIPortal != null) {
                currentNavPath = showedUIPortal.getNavPath();
            }
            if (currentNavPath != null && currentNavPath.getNavigation().getKey().equals((Object)targetNav.getKey())) {
                if (!currentNavPath.getURI().equals(targetNode.getURI())) {
                    showedUIPortal.setNavPath(targetNode);
                }
            } else {
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                uiWorkingWS.setRenderedChild("UIViewWS");
                uiPortalApp.setModeState(0);
                showedUIPortal = uiPortalApp.getCachedUIPortal(targetNav.getKey());
                if (showedUIPortal != null) {
                    showedUIPortal.setNavPath(targetNode);
                    uiPortalApp.setCurrentSite(showedUIPortal);
                    DataStorage storageService = (DataStorage)uiPortalApp.getApplicationComponent(DataStorage.class);
                    PortalConfig associatedPortalConfig = storageService.getPortalConfig(targetNav.getKey().getTypeName(), targetNav.getKey().getName());
                    UserPortalConfig userPortalConfig = pcontext.getUserPortalConfig();
                    userPortalConfig.setPortalConfig(associatedPortalConfig);
                } else {
                    showedUIPortal = this.buildUIPortal(targetNav.getKey(), uiPortalApp, pcontext.getUserPortalConfig());
                    if (showedUIPortal == null) {
                        return;
                    }
                    showedUIPortal.setNavPath(targetNode);
                    uiPortalApp.setCurrentSite(showedUIPortal);
                    uiPortalApp.putCachedUIPortal(showedUIPortal);
                }
            }
            showedUIPortal.refreshUIPage();
            pcontext.setFullRender(true);
            pcontext.addUIComponentToUpdateByAjax(uiPortalApp.getChildById("UIWorkingWorkspace"));
        }

        private UIPortal buildUIPortal(SiteKey siteKey, UIPortalApplication uiPortalApp, UserPortalConfig userPortalConfig) throws Exception {
            DataStorage storage = (DataStorage)uiPortalApp.getApplicationComponent(DataStorage.class);
            if (storage == null) {
                return null;
            }
            PortalConfig portalConfig = storage.getPortalConfig(siteKey.getTypeName(), siteKey.getName());
            Container layout = portalConfig.getPortalLayout();
            if (layout != null) {
                userPortalConfig.setPortalConfig(portalConfig);
            }
            UIPortal uiPortal = (UIPortal)uiPortalApp.createUIComponent(UIPortal.class, null, null);
            PortalDataMapper.toUIPortal(uiPortal, userPortalConfig.getPortalConfig());
            return uiPortal;
        }
    }
}

