/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.rest.services.InvitationsPortlet;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/homepage/intranet/invitations/")
@Produces(value={"application/json"})
public class PeopleAndSpacesRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(PeopleAndSpacesRestService.class);
    private static final CacheControl cacheControl;
    private static final String OPENSOCIAL_VIEWER_ID = "opensocial_viewer_id";
    private static final String INVITATION_TYPE = "invitationType";
    private static final String PEOPLE_INVITATION_TYPE = "people";
    private static final String SPACE_INVITATION_TYPE = "space";
    private static final String SENDER_NAME = "senderName";
    private static final String RELATION_ID = "relationId";
    private static final String SENDER_AVATAR_URL = "senderAvatarUrl";
    private static final String SENDER_POSITION = "senderPosition";
    private static final String SPACE_DISPLAY_NAME = "spaceDisplayName";
    private static final String SPACE_ID = "spaceId";
    private static final String SPACE_AVATAR_URL = "spaceAvatarUrl";
    private static final String MEMBERS_NUMBER = "membersNumber";
    private static final String SPACE_REGISTRATION = "spaceRegistration";
    private static final String SENDER_PROFILE_URL = "profile_url";
    private SpaceService spaceService = null;
    private IdentityManager identityManager = null;
    private RelationshipManager relationshipManager = null;

    public PeopleAndSpacesRestService(SpaceService spaceService, IdentityManager identityManager, RelationshipManager relationshipManager) {
        this.spaceService = spaceService;
        this.identityManager = identityManager;
        this.relationshipManager = relationshipManager;
    }

    @GET
    @Path(value="allInvitations")
    public Response getAllInvitations(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            List<Object> invitedSpaces = new ArrayList();
            ListAccess invitedSpacesListAccess = this.spaceService.getInvitedSpacesWithListAccess(userId);
            Space[] spaces = (Space[])invitedSpacesListAccess.load(0, invitedSpacesListAccess.getSize());
            if (spaces.length > 0) {
                invitedSpaces = Arrays.asList(spaces);
            }
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId, false);
            ListAccess incomingRelationship = this.relationshipManager.getIncomingWithListAccess(identity);
            Identity[] senders = (Identity[])incomingRelationship.load(0, incomingRelationship.getSize());
            JSONArray jsonArray = new JSONArray();
            for (Space space : invitedSpaces) {
                String avatar = space.getAvatarUrl();
                JSONObject json = new JSONObject();
                json.put(INVITATION_TYPE, (Object)SPACE_INVITATION_TYPE);
                json.put(SPACE_DISPLAY_NAME, (Object)space.getDisplayName());
                json.put(SPACE_AVATAR_URL, (Object)avatar);
                json.put(SPACE_ID, (Object)space.getId());
                json.put(MEMBERS_NUMBER, space.getMembers().length);
                json.put(SPACE_REGISTRATION, (Object)space.getRegistration());
                jsonArray.put((Object)json);
            }
            for (Identity sender : senders) {
                String avatar = sender.getProfile().getAvatarImageSource();
                JSONObject json = new JSONObject();
                json.put(INVITATION_TYPE, (Object)PEOPLE_INVITATION_TYPE);
                json.put(SENDER_NAME, (Object)sender.getProfile().getFullName());
                json.put(RELATION_ID, (Object)this.relationshipManager.get(identity, sender).getId());
                json.put(SENDER_AVATAR_URL, (Object)avatar);
                json.put(SENDER_POSITION, (Object)sender.getProfile().getPosition());
                json.put(SENDER_PROFILE_URL, (Object)sender.getProfile().getUrl());
                jsonArray.put((Object)json);
            }
            return Response.ok((Object)jsonArray.toString(), (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error in space invitation rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (NullPointerException e) {
            return this.getViewerId(uriInfo);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getViewerId(UriInfo uriInfo) {
        String[] queryParts;
        URI uri = uriInfo.getRequestUri();
        String requestString = uri.getQuery();
        if (requestString == null) {
            return null;
        }
        for (String queryPart : queryParts = requestString.split("&")) {
            if (!queryPart.startsWith(OPENSOCIAL_VIEWER_ID)) continue;
            return queryPart.substring(queryPart.indexOf("=") + 1, queryPart.length());
        }
        return null;
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }
}

