/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.model.Document;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.gatein.api.Portal;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteType;

public class DocumentServiceImpl
implements DocumentService {
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String EXO_LAST_MODIFIER_PROP = "exo:lastModifier";
    public static final String EXO_DATE_CREATED_PROP = "exo:dateCreated";
    public static final String JCR_LAST_MODIFIED_PROP = "jcr:lastModified";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String EXO_OWNER_PROP = "exo:owner";
    public static final String EXO_TITLE_PROP = "exo:title";
    public static final String CURRENT_STATE_PROP = "publication:currentState";
    public static final String DOCUMENTS_APP_NAVIGATION_NODE_NAME = "documents";
    public static final String DOCUMENT_NOT_FOUND = "?path=doc-not-found";
    private static final String DOCUMENTS_NODE = "Documents";
    private static final String SHARED_NODE = "Shared";
    private static final Log LOG = ExoLogger.getLogger(DocumentServiceImpl.class);
    private ManageDriveService manageDriveService;
    private Portal portal;
    private SessionProviderService sessionProviderService;
    private RepositoryService repoService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private LinkManager linkManager;

    public DocumentServiceImpl(ManageDriveService manageDriveService, Portal portal, SessionProviderService sessionProviderService, RepositoryService repoService, NodeHierarchyCreator nodeHierarchyCreator, LinkManager linkManager) {
        this.manageDriveService = manageDriveService;
        this.sessionProviderService = sessionProviderService;
        this.repoService = repoService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.portal = portal;
        this.linkManager = linkManager;
    }

    @Override
    public Document findDocById(String documentId) throws RepositoryException {
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository manageRepo = repositoryService.getCurrentRepository();
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        String ws = documentId.split(":/")[0];
        String uuid = documentId.split(":/")[1];
        javax.jcr.Node node = sessionProvider.getSession(ws, manageRepo).getNodeByUUID(uuid);
        String title = node.hasProperty(EXO_TITLE_PROP) ? node.getProperty(EXO_TITLE_PROP).getString() : "";
        String id = node.isNodeType(MIX_REFERENCEABLE) ? node.getUUID() : "";
        String state = node.hasProperty(CURRENT_STATE_PROP) ? node.getProperty(CURRENT_STATE_PROP).getValue().getString() : "";
        String author = node.hasProperty(EXO_OWNER_PROP) ? node.getProperty(EXO_OWNER_PROP).getString() : "";
        Calendar lastModified = node.hasNode(JCR_CONTENT) ? node.getNode(JCR_CONTENT).getProperty(JCR_LAST_MODIFIED_PROP).getValue().getDate() : null;
        Calendar dateCreated = node.hasProperty(EXO_DATE_CREATED_PROP) ? node.getProperty(EXO_DATE_CREATED_PROP).getValue().getDate() : null;
        String lastEditor = node.hasProperty(EXO_LAST_MODIFIER_PROP) ? node.getProperty(EXO_LAST_MODIFIER_PROP).getValue().getString() : "";
        Document doc = new Document(id, node.getName(), title, node.getPath(), ws, state, author, lastEditor, lastModified, dateCreated);
        return doc;
    }

    @Override
    public String getDocumentUrlInPersonalDocuments(javax.jcr.Node currentNode, String username) throws Exception {
        javax.jcr.Node rootNode = null;
        try {
            SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            ManageableRepository repository = this.repoService.getCurrentRepository();
            Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            this.nodeHierarchyCreator.getJcrPath("usersPath");
            rootNode = (javax.jcr.Node)session.getItem(this.nodeHierarchyCreator.getJcrPath("usersPath") + this.getPrivatePath(username));
            String sharedLink = this.getSharedLink(currentNode, rootNode);
            return sharedLink;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public String getDocumentUrlInSpaceDocuments(javax.jcr.Node currentNode, String spaceId) throws Exception {
        javax.jcr.Node rootNode = null;
        try {
            SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            ManageableRepository repository = this.repoService.getCurrentRepository();
            Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            this.nodeHierarchyCreator.getJcrPath("groupsPath");
            rootNode = (javax.jcr.Node)session.getItem(this.nodeHierarchyCreator.getJcrPath("groupsPath") + spaceId);
            String sharedLink = this.getSharedLink(currentNode, rootNode);
            return sharedLink;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public String getShortLinkInDocumentsApp(String workspaceName, String nodeId) throws Exception {
        StringBuilder url = new StringBuilder();
        url.append("/").append(CommonsUtils.getRestContextName()).append("/private/documents/view/").append(workspaceName).append("/").append(nodeId);
        return url.toString();
    }

    @Override
    public String getLinkInDocumentsApp(String nodePath) throws Exception {
        if (nodePath == null) {
            return null;
        }
        DriveData drive = this.getDriveOfNode(nodePath);
        return this.getLinkInDocumentsApp(nodePath, drive);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getLinkInDocumentsApp(String nodePath, DriveData drive) throws Exception {
        if (nodePath == null) {
            return null;
        }
        String containerName = WCMCoreUtils.getService(PortalContainerInfo.class).getContainerName();
        StringBuffer url = new StringBuffer();
        url.append("/").append(containerName);
        if (drive == null) {
            SiteKey siteKey = this.getDefaultSiteKey();
            url.append("/").append(siteKey.getName()).append("/").append(DOCUMENTS_APP_NAVIGATION_NODE_NAME).append(DOCUMENT_NOT_FOUND);
            return url.toString();
        }
        String encodedDriveName = URLEncoder.encode(drive.getName(), "UTF-8");
        String encodedNodePath = URLEncoder.encode(nodePath, "UTF-8");
        if (drive.getName().equals("Groups")) {
            String groupPageName;
            String groupId = drive.getParameters().get("groupId");
            if (groupId == null) throw new Exception("Cannot get group id from node path " + nodePath);
            String[] splitedGroupId = groupId.split("/");
            if (splitedGroupId != null && splitedGroupId.length == 3 && splitedGroupId[1].equals("spaces")) {
                String rootNavigation = this.getSpaceRootNavigationNodeURI(groupId);
                groupPageName = rootNavigation + "/" + DOCUMENTS_APP_NAVIGATION_NODE_NAME;
            } else {
                groupPageName = DOCUMENTS_APP_NAVIGATION_NODE_NAME;
            }
            url.append("/g/").append(groupId.replaceAll("/", ":")).append("/").append(groupPageName).append("?path=").append(encodedDriveName).append(encodedNodePath).append("&").append("groupId").append("=").append(groupId);
            return url.toString();
        } else if (drive.getName().equals("User Documents") || drive.getName().equals("Personal Documents")) {
            SiteKey siteKey = this.getDefaultSiteKey();
            url.append("/").append(siteKey.getName()).append("/").append(DOCUMENTS_APP_NAVIGATION_NODE_NAME).append("?path=" + encodedDriveName + encodedNodePath);
            String[] splitedNodePath = nodePath.split("/");
            if (splitedNodePath == null || splitedNodePath.length < 6) return url.toString();
            String userId = splitedNodePath[5];
            url.append("&").append("userId").append("=").append(userId);
            return url.toString();
        } else {
            SiteKey siteKey = this.getDefaultSiteKey();
            url.append("/").append(siteKey.getName()).append("/").append(DOCUMENTS_APP_NAVIGATION_NODE_NAME).append("?path=" + encodedDriveName + encodedNodePath);
        }
        return url.toString();
    }

    protected String getSpaceRootNavigationNodeURI(String spaceGroupId) throws Exception {
        Node navigationRootNode;
        String navigationName = null;
        Navigation spaceNavigation = this.portal.getNavigation(new SiteId(SiteType.SPACE, spaceGroupId));
        if (spaceNavigation != null && (navigationRootNode = spaceNavigation.getRootNode(Nodes.visitChildren())) != null && navigationRootNode.iterator().hasNext()) {
            Node node = (Node)navigationRootNode.iterator().next();
            navigationName = node.getName();
        }
        return navigationName;
    }

    @Override
    public DriveData getDriveOfNode(String nodePath) throws Exception {
        return this.getDriveOfNode(nodePath, ConversationState.getCurrent().getIdentity().getUserId(), Utils.getMemberships());
    }

    @Override
    public DriveData getDriveOfNode(String nodePath, String userId, List<String> memberships) throws Exception {
        int groupDocumentsRootNodeName;
        DriveData nodeDrive = null;
        List<DriveData> drives = this.manageDriveService.getDriveByUserRoles(userId, memberships);
        String[] splitedPath = nodePath.split("/");
        if (splitedPath != null && splitedPath.length >= 2 && splitedPath.length >= 6 && splitedPath[1].equals("Users") && (nodeDrive = splitedPath[5].equals(userId) ? this.manageDriveService.getDriveByName("Personal Documents") : this.manageDriveService.getDriveByName("User Documents")) != null) {
            nodeDrive = nodeDrive.clone();
            nodeDrive.getParameters().put("userId", splitedPath[2] + "/" + splitedPath[3] + "/" + splitedPath[4] + "/" + splitedPath[5]);
        }
        if (splitedPath != null && splitedPath.length >= 2 && splitedPath[1].equals("Groups") && (groupDocumentsRootNodeName = nodePath.indexOf("/Documents")) >= 0) {
            String groupId = nodePath.substring("Groups".length() + 1, groupDocumentsRootNodeName);
            nodeDrive = this.manageDriveService.getDriveByName(groupId.replaceAll("/", "."));
        }
        if (nodeDrive == null) {
            for (DriveData drive : drives) {
                if (!nodePath.startsWith(drive.getResolvedHomePath()) || nodeDrive != null && nodeDrive.getResolvedHomePath().length() >= drive.getResolvedHomePath().length()) continue;
                nodeDrive = drive;
            }
        }
        return nodeDrive;
    }

    protected UserPortalConfig getDefaultUserPortalConfig() throws Exception {
        UserPortalConfigService userPortalConfigSer = WCMCoreUtils.getService(UserPortalConfigService.class);
        UserPortalContext NULL_CONTEXT = new UserPortalContext(){

            public ResourceBundle getBundle(UserNavigation navigation) {
                return null;
            }

            public Locale getUserLocale() {
                return Locale.ENGLISH;
            }
        };
        String remoteId = ConversationState.getCurrent().getIdentity().getUserId();
        UserPortalConfig userPortalCfg = userPortalConfigSer.getUserPortalConfig(userPortalConfigSer.getDefaultPortal(), remoteId, NULL_CONTEXT);
        return userPortalCfg;
    }

    protected SiteKey getDefaultSiteKey() throws Exception {
        UserPortalConfig prc = this.getDefaultUserPortalConfig();
        if (prc == null) {
            return null;
        }
        SiteKey siteKey = SiteKey.portal((String)prc.getPortalConfig().getName());
        return siteKey;
    }

    private String getPrivatePath(String user) {
        return "/" + user.substring(0, 1) + "___/" + user.substring(0, 2) + "___/" + user.substring(0, 3) + "___/" + user + "/Private";
    }

    private String getSharedLink(javax.jcr.Node currentNode, javax.jcr.Node rootNode) {
        javax.jcr.Node shared = null;
        javax.jcr.Node link = null;
        try {
            rootNode = rootNode.getNode(DOCUMENTS_NODE);
            shared = !rootNode.hasNode(SHARED_NODE) ? rootNode.addNode(SHARED_NODE) : rootNode.getNode(SHARED_NODE);
            if (currentNode.isNodeType("exo:symlink")) {
                currentNode = this.linkManager.getTarget(currentNode);
            }
            ArrayList<String> path = new ArrayList<String>();
            javax.jcr.Node targetNode = null;
            boolean existingSymlink = false;
            NodeIterator it = shared.getNodes();
            while (it.hasNext()) {
                javax.jcr.Node node = it.nextNode();
                path.add(((NodeImpl)node).getInternalPath().getAsString());
                if (!path.contains(((NodeImpl)shared).getInternalPath().getAsString() + "[]" + currentNode.getName() + ":1")) continue;
                existingSymlink = true;
                targetNode = node;
                break;
            }
            link = existingSymlink ? targetNode : this.linkManager.createLink(shared, currentNode);
            return CommonsUtils.getCurrentDomain() + this.getShortLinkInDocumentsApp(link.getSession().getWorkspace().getName(), ((NodeImpl)link).getInternalIdentifier());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }
}

