/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.seo.impl;

import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.ecm.utils.MessageDigester;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.seo.PageMetadataModel;
import org.exoplatform.services.seo.SEOConfig;
import org.exoplatform.services.seo.SEOService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SEOServiceImpl
implements SEOService {
    private ExoCache<String, Object> cache;
    public static final String EMPTY_CACHE_ENTRY = "EMPTY";
    public static String METADATA_BASE_PATH = "SEO";
    public static final String LANGUAGES = "seo-languages";
    public static String METADATA_PAGE_PATH = "pages";
    public static String METADATA_CONTENT_PATH = "contents";
    public static String SITEMAP_NAME = "sitemaps";
    public static String ROBOTS_NAME = "robots";
    private static String PUBLIC_MODE = "public";
    private static String PRIVATE_MODE = "private";
    private static final String CACHE_NAME = "ecms.seo";
    private List<String> robotsindex = new ArrayList<String>();
    private List<String> robotsfollow = new ArrayList<String>();
    private List<String> frequency = new ArrayList<String>();
    private SEOConfig seoConfig = null;
    private boolean isCached = true;

    public SEOServiceImpl(InitParams initParams) throws Exception {
        ObjectParameter param = initParams.getObjectParam("seo.config");
        if (param != null) {
            this.seoConfig = (SEOConfig)param.getObject();
            this.robotsindex = this.seoConfig.getRobotsIndex();
            this.robotsfollow = this.seoConfig.getRobotsFollow();
            this.frequency = this.seoConfig.getFrequency();
        }
        this.cache = WCMCoreUtils.getService(CacheService.class).getCacheInstance(CACHE_NAME);
    }

    @Override
    public List<String> getRobotsIndexOptions() {
        return this.robotsindex;
    }

    @Override
    public List<String> getRobotsFollowOptions() {
        return this.robotsfollow;
    }

    @Override
    public List<String> getFrequencyOptions() {
        return this.frequency;
    }

    @Override
    public void storeMetadata(PageMetadataModel metaModel, String portalName, boolean onContent, String language) throws Exception {
        String uri = metaModel.getUri();
        String cachedHash = this.getPageOrContentCacheKey(uri, language);
        if (this.cache.get((Serializable)((Object)cachedHash)) != null) {
            this.cache.remove((Serializable)((Object)cachedHash));
        }
        String pageReference = metaModel.getPageReference();
        cachedHash = this.getPageOrContentCacheKey(metaModel.getPageReference(), language);
        if (this.cache.get((Serializable)((Object)cachedHash)) != null) {
            this.cache.remove((Serializable)((Object)cachedHash));
        }
        String title = metaModel.getTitle();
        String keyword = metaModel.getKeywords();
        String description = metaModel.getDescription();
        String robots = metaModel.getRobotsContent();
        String fullStatus = metaModel.getFullStatus();
        boolean sitemap = metaModel.getSitemap();
        float priority = metaModel.getPriority();
        String frequency = metaModel.getFrequency();
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Session session = null;
        LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
        Node dummyNode = livePortalManagerService.getLivePortal(sessionProvider, portalName);
        session = dummyNode.getSession();
        if (!dummyNode.hasNode(METADATA_BASE_PATH)) {
            dummyNode.addNode(METADATA_BASE_PATH);
            session.save();
        }
        this.updateRobots(dummyNode, portalName);
        Node node = null;
        if (onContent) {
            node = session.getNodeByUUID(uri);
            if (!node.isNodeType("mix:referenceable")) {
                node.addMixin("mix:referenceable");
            }
        } else {
            String uuid;
            session = sessionProvider.getSession("portal-system", WCMCoreUtils.getRepository());
            node = session.getNodeByUUID(uuid = Util.getUIPortal().getSelectedUserNode().getId());
            if (!node.isNodeType("exo:seoMetadata")) {
                node.addMixin("exo:seoMetadata");
            }
        }
        Node languageNode = null;
        languageNode = node.hasNode(LANGUAGES) ? node.getNode(LANGUAGES) : node.addNode(LANGUAGES);
        if (languageNode.canAddMixin("exo:hiddenable")) {
            languageNode.addMixin("exo:hiddenable");
        }
        session.save();
        Node seoNode = null;
        seoNode = languageNode.hasNode(language) ? languageNode.getNode(language) : languageNode.addNode(language);
        if (!seoNode.isNodeType("mix:referenceable")) {
            seoNode.addMixin("mix:referenceable");
        }
        if (seoNode.isNodeType("exo:pageMetadata")) {
            seoNode.setProperty("exo:metaKeywords", keyword);
            seoNode.setProperty("exo:metaDescription", description);
            seoNode.setProperty("exo:metaFully", fullStatus);
            if (!onContent) {
                seoNode.setProperty("exo:metaTitle", title);
                seoNode.setProperty("exo:metaRobots", robots);
                seoNode.setProperty("exo:metaSitemap", sitemap);
                seoNode.setProperty("exo:metaPriority", (double)priority);
                seoNode.setProperty("exo:metaFrequency", frequency);
                this.updateSiteMap(uri, priority, frequency, sitemap, portalName);
            }
            String hash = null;
            hash = onContent ? cachedHash : this.getPageOrContentCacheKey(pageReference, language);
            if (hash != null) {
                this.cache.put((Serializable)((Object)hash), (Object)metaModel);
            }
        } else {
            String hash = null;
            seoNode.addMixin("exo:pageMetadata");
            seoNode.setProperty("exo:metaKeywords", keyword);
            seoNode.setProperty("exo:metaDescription", description);
            seoNode.setProperty("exo:metaFully", fullStatus);
            if (onContent) {
                seoNode.setProperty("exo:metaUri", seoNode.getUUID());
                hash = this.getHash(seoNode.getUUID() + language);
            } else {
                seoNode.setProperty("exo:metaTitle", title);
                seoNode.setProperty("exo:metaUri", pageReference);
                seoNode.setProperty("exo:metaRobots", robots);
                seoNode.setProperty("exo:metaSitemap", sitemap);
                seoNode.setProperty("exo:metaPriority", (double)priority);
                seoNode.setProperty("exo:metaFrequency", frequency);
                this.updateSiteMap(uri, priority, frequency, sitemap, portalName);
                hash = this.getPageOrContentCacheKey(pageReference, language);
            }
            if (hash != null) {
                this.cache.put((Serializable)((Object)hash), (Object)metaModel);
            }
        }
        session.save();
    }

    private String getPageOrContentCacheKey(String uri, String language) throws Exception {
        return this.getHash(uri + language);
    }

    @Override
    public String getState(String path, String language, boolean onContent) throws Exception {
        Node seoNode;
        String state = "Empty";
        Node node = null;
        String hash = null;
        PageMetadataModel metaModel = null;
        if (onContent) {
            node = this.getContentNode(path);
            hash = node == null ? "" : this.getPageOrContentCacheKey(node.getUUID(), language);
            metaModel = (PageMetadataModel)this.getCachedEntry(hash, false);
            if (metaModel != null) {
                return metaModel.getFullStatus();
            }
        } else {
            hash = this.getPageOrContentCacheKey(path, language);
            metaModel = (PageMetadataModel)this.getCachedEntry(hash, true);
            if (this.isNullObject(metaModel)) {
                return null;
            }
            if (metaModel != null) {
                return metaModel.getFullStatus();
            }
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            Session session = sessionProvider.getSession("portal-system", WCMCoreUtils.getRepository());
            String uuid = Util.getUIPortal().getSelectedUserNode().getId();
            node = session.getNodeByUUID(uuid);
        }
        if (node.hasNode("seo-languages/" + language) && (seoNode = node.getNode("seo-languages/" + language)).isNodeType("exo:pageMetadata") && seoNode.hasProperty("exo:metaFully")) {
            return seoNode.getProperty("exo:metaFully").getString();
        }
        return state;
    }

    private boolean isNullObject(PageMetadataModel metaModel) {
        return metaModel == PageMetadataModel.NULL_PAGE_METADATA_MODEL;
    }

    private Object getCachedEntry(String hash, boolean cacheNull) {
        Object object = this.cache.get((Serializable)((Object)hash));
        if (cacheNull) {
            if (object == null) {
                this.cache.put((Serializable)((Object)hash), (Object)EMPTY_CACHE_ENTRY);
            } else if (EMPTY_CACHE_ENTRY.equals(object)) {
                return PageMetadataModel.NULL_PAGE_METADATA_MODEL;
            }
        }
        return object;
    }

    @Override
    public PageMetadataModel getMetadata(ArrayList<String> params, String pageReference, String language) throws Exception {
        PageMetadataModel metaModel = null;
        if (params != null) {
            metaModel = this.getContentMetadata(params, language);
            if (metaModel == null) {
                metaModel = this.getPageMetadata(pageReference, language);
            }
        } else {
            metaModel = this.getPageMetadata(pageReference, language);
        }
        return metaModel;
    }

    @Override
    public PageMetadataModel getContentMetadata(ArrayList<String> params, String language) throws Exception {
        String hash;
        PageMetadataModel metaModel = null;
        String pageUri = null;
        Node contentNode = null;
        for (int i = 0; i < params.size() && (contentNode = this.getContentNode(params.get(i).toString())) == null; ++i) {
        }
        if (contentNode == null) {
            return null;
        }
        if (!contentNode.isNodeType("mix:referenceable")) {
            contentNode.addMixin("mix:referenceable");
        }
        if ((metaModel = (PageMetadataModel)this.getCachedEntry(hash = this.getPageOrContentCacheKey(contentNode.getUUID(), language), false)) == null && contentNode.hasNode("seo-languages/" + language)) {
            Node seoNode = contentNode.getNode("seo-languages/" + language);
            if (!seoNode.isNodeType("mix:referenceable")) {
                seoNode.addMixin("mix:referenceable");
            }
            if (seoNode.isNodeType("exo:pageMetadata")) {
                metaModel = new PageMetadataModel();
                metaModel.setUri(pageUri);
                if (seoNode.hasProperty("exo:metaKeywords")) {
                    metaModel.setKeywords(seoNode.getProperty("exo:metaKeywords").getString());
                }
                if (seoNode.hasProperty("exo:metaDescription")) {
                    metaModel.setDescription(seoNode.getProperty("exo:metaDescription").getString());
                }
                if (seoNode.hasProperty("exo:metaRobots")) {
                    metaModel.setRobotsContent(seoNode.getProperty("exo:metaRobots").getString());
                }
                if (seoNode.hasProperty("exo:metaSitemap")) {
                    metaModel.setSiteMap(Boolean.parseBoolean(seoNode.getProperty("exo:metaSitemap").getString()));
                }
                if (seoNode.hasProperty("exo:metaPriority")) {
                    metaModel.setPriority(Long.parseLong(seoNode.getProperty("exo:metaPriority").getString()));
                }
                if (seoNode.hasProperty("exo:metaFrequency")) {
                    metaModel.setFrequency(seoNode.getProperty("exo:metaFrequency").getString());
                }
                if (seoNode.hasProperty("exo:metaFully")) {
                    metaModel.setFullStatus(seoNode.getProperty("exo:metaFully").getString());
                }
                this.cache.put((Serializable)((Object)hash), (Object)metaModel);
            }
        }
        return metaModel;
    }

    @Override
    public PageMetadataModel getPageMetadata(String pageUri, String language) throws Exception {
        Node seoNode;
        String uuid;
        SessionProvider sessionProvider;
        Session session;
        Node pageNode;
        PageMetadataModel metaModel = null;
        String hash = this.getPageOrContentCacheKey(pageUri, language);
        metaModel = (PageMetadataModel)this.getCachedEntry(hash, true);
        if (this.isNullObject(metaModel)) {
            return null;
        }
        if (metaModel == null && (pageNode = (session = (sessionProvider = WCMCoreUtils.getSystemSessionProvider()).getSession("portal-system", WCMCoreUtils.getRepository())).getNodeByUUID(uuid = Util.getUIPortal().getSelectedUserNode().getId())) != null && pageNode.hasNode("seo-languages/" + language) && (seoNode = pageNode.getNode("seo-languages/" + language)).isNodeType("exo:pageMetadata")) {
            metaModel = new PageMetadataModel();
            if (seoNode.hasProperty("exo:metaTitle")) {
                metaModel.setTitle(seoNode.getProperty("exo:metaTitle").getString());
            }
            if (seoNode.hasProperty("exo:metaKeywords")) {
                metaModel.setKeywords(seoNode.getProperty("exo:metaKeywords").getString());
            }
            if (seoNode.hasProperty("exo:metaDescription")) {
                metaModel.setDescription(seoNode.getProperty("exo:metaDescription").getString());
            }
            if (seoNode.hasProperty("exo:metaRobots")) {
                metaModel.setRobotsContent(seoNode.getProperty("exo:metaRobots").getString());
            }
            if (seoNode.hasProperty("exo:metaSitemap")) {
                metaModel.setSiteMap(Boolean.parseBoolean(seoNode.getProperty("exo:metaSitemap").getString()));
            }
            if (seoNode.hasProperty("exo:metaPriority")) {
                metaModel.setPriority(Long.parseLong(seoNode.getProperty("exo:metaPriority").getString()));
            }
            if (seoNode.hasProperty("exo:metaFrequency")) {
                metaModel.setFrequency(seoNode.getProperty("exo:metaFrequency").getString());
            }
            if (seoNode.hasProperty("exo:metaFully")) {
                metaModel.setFullStatus(seoNode.getProperty("exo:metaFully").getString());
            }
            this.cache.put((Serializable)((Object)hash), (Object)metaModel);
        }
        return metaModel;
    }

    @Override
    public List<Locale> getSEOLanguages(String portalName, String seoPath, boolean onContent) throws Exception {
        ArrayList<Locale> languages = new ArrayList<Locale>();
        Node languagesNode = null;
        if (onContent) {
            Node contentNode = null;
            contentNode = this.getContentNode(seoPath);
            if (contentNode != null && contentNode.hasNode(LANGUAGES)) {
                languagesNode = contentNode.getNode(LANGUAGES);
            }
        } else {
            String uuid;
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            Session session = sessionProvider.getSession("portal-system", WCMCoreUtils.getRepository());
            Node pageNode = session.getNodeByUUID(uuid = Util.getUIPortal().getSelectedUserNode().getId());
            if (pageNode != null && pageNode.hasNode(LANGUAGES)) {
                languagesNode = pageNode.getNode(LANGUAGES);
            }
        }
        if (languagesNode != null) {
            NodeIterator iter = languagesNode.getNodes();
            while (iter.hasNext()) {
                String lang = iter.nextNode().getName();
                String[] arr = lang.split("_");
                if (arr.length > 1) {
                    languages.add(new Locale(arr[0], arr[1]));
                    continue;
                }
                languages.add(new Locale(lang));
            }
            Collections.sort(languages, new SEOItemComparator());
            return languages;
        }
        return languages;
    }

    @Override
    public void removePageMetadata(PageMetadataModel metaModel, String portalName, boolean onContent, String language) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        ManageableRepository currentRepo = WCMCoreUtils.getRepository();
        Session session = sessionProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
        String hash = "";
        Node node = null;
        if (onContent) {
            node = session.getNodeByUUID(metaModel.getUri());
        } else {
            session = sessionProvider.getSession("portal-system", WCMCoreUtils.getRepository());
            String uuid = Util.getUIPortal().getSelectedUserNode().getId();
            node = session.getNodeByUUID(uuid);
        }
        Node seoNode = null;
        if (node.hasNode("seo-languages/" + language)) {
            seoNode = node.getNode("seo-languages/" + language);
        }
        if (seoNode != null) {
            seoNode.remove();
            hash = onContent ? this.getHash(metaModel.getUri() + language) : this.getHash(metaModel.getPageReference() + language);
            this.cache.remove((Serializable)((Object)hash));
        }
        session.save();
    }

    public void updateSiteMap(String uri, float priority, String frequency, boolean visibleSitemap, String portalName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
        Node dummyNode = livePortalManagerService.getLivePortal(sessionProvider, portalName);
        Session session = dummyNode.getSession();
        if ((uri = this.getStandardURL(uri)) == null) {
            uri = "";
        }
        String uri_clone = "";
        String public_path = "/" + PUBLIC_MODE + "/";
        String private_path = "/" + PRIVATE_MODE + "/";
        if (uri.indexOf(public_path) > 0) {
            uri_clone = uri.replaceFirst(public_path, private_path);
        } else if (uri.indexOf(private_path) > 0) {
            uri_clone = uri.replaceFirst(private_path, public_path);
        }
        String sitemapData = "";
        if (!dummyNode.getNode(METADATA_BASE_PATH).hasNode(SITEMAP_NAME)) {
            dummyNode.getNode(METADATA_BASE_PATH).addNode(SITEMAP_NAME, "nt:file");
            Node simapFolder = dummyNode.getNode(METADATA_BASE_PATH + "/" + SITEMAP_NAME);
            Node sitemapNode = simapFolder.addNode("jcr:content", "nt:resource");
            sitemapNode.setProperty("jcr:mimeType", "text/xml");
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("urlset");
            rootElement.setAttribute("xmlns", "http://www.sitemaps.org/schemas/sitemap/0.9");
            rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            rootElement.setAttribute("xsi:schemaLocation", "http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd");
            doc.appendChild(rootElement);
            if (visibleSitemap) {
                Element urlElement = doc.createElement("url");
                rootElement.appendChild(urlElement);
                Element locElement = doc.createElement("loc");
                locElement.setTextContent(uri);
                urlElement.appendChild(locElement);
                Element freqElement = doc.createElement("changefreq");
                freqElement.setTextContent(frequency);
                urlElement.appendChild(freqElement);
                Element priorityElement = doc.createElement("priority");
                if (priority >= 0.0f) {
                    priorityElement.setTextContent(String.valueOf(priority));
                    urlElement.appendChild(priorityElement);
                }
                if (uri_clone != null && uri_clone.length() > 0) {
                    urlElement = doc.createElement("url");
                    rootElement.appendChild(urlElement);
                    locElement = doc.createElement("loc");
                    locElement.setTextContent(uri_clone);
                    urlElement.appendChild(locElement);
                    freqElement = doc.createElement("changefreq");
                    freqElement.setTextContent(frequency);
                    urlElement.appendChild(freqElement);
                    if (priority >= 0.0f) {
                        priorityElement = doc.createElement("priority");
                        priorityElement.setTextContent(String.valueOf(priority));
                        urlElement.appendChild(priorityElement);
                    }
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            transformer.transform(source, new StreamResult(writer));
            sitemapData = writer.toString();
            sitemapNode.setProperty("jcr:data", sitemapData);
            sitemapNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
            session.save();
        } else {
            int i;
            Node sitemapFolder = dummyNode.getNode(METADATA_BASE_PATH + "/" + SITEMAP_NAME);
            Node sitemapNode = sitemapFolder.getNode("jcr:content");
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputStream stream = sitemapNode.getProperty("jcr:data").getStream();
            Document doc = docBuilder.parse(stream);
            boolean fLoc = false;
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            ArrayList<org.w3c.dom.Node> arrNodes = new ArrayList<org.w3c.dom.Node>();
            NodeList listOfUrls = doc.getElementsByTagName("url");
            for (i = 0; i < listOfUrls.getLength(); ++i) {
                String locationValue;
                Element urlElement;
                NodeList locList;
                Element locElement;
                org.w3c.dom.Node urlNode = listOfUrls.item(i);
                if (urlNode.getNodeType() != 1 || (locElement = (Element)(locList = (urlElement = (Element)urlNode).getElementsByTagName("loc")).item(0)).getChildNodes().item(0) == null || !((locationValue = locElement.getChildNodes().item(0).getNodeValue()) != null & (locationValue.trim().equals(uri) || locationValue.trim().equals(uri_clone)))) continue;
                fLoc = true;
                if (visibleSitemap) {
                    org.w3c.dom.Node freqNode = urlElement.getElementsByTagName("changefreq").item(0);
                    freqNode.setTextContent(frequency);
                    if (!(priority >= 0.0f)) continue;
                    org.w3c.dom.Node priorityNode = urlElement.getElementsByTagName("priority").item(0);
                    if (priorityNode == null) {
                        Element priorityElement = doc.createElement("priority");
                        priorityElement.setTextContent(String.valueOf(priority));
                        urlElement.appendChild(priorityElement);
                        continue;
                    }
                    priorityNode.setTextContent(String.valueOf(priority));
                    continue;
                }
                arrNodes.add(urlNode);
            }
            if (arrNodes != null && arrNodes.size() > 0) {
                for (i = 0; i < arrNodes.size(); ++i) {
                    root.removeChild((org.w3c.dom.Node)arrNodes.get(i));
                }
            }
            if (!fLoc && visibleSitemap) {
                Element urlElement = doc.createElement("url");
                Element locElement = doc.createElement("loc");
                locElement.setTextContent(uri);
                Element freqElement = doc.createElement("changefreq");
                freqElement.setTextContent(frequency);
                urlElement.appendChild(locElement);
                urlElement.appendChild(freqElement);
                Element priorityElement = doc.createElement("priority");
                if (priority >= 0.0f) {
                    priorityElement.setTextContent(String.valueOf(priority));
                    urlElement.appendChild(priorityElement);
                }
                root.appendChild(urlElement);
                if (uri_clone != null && uri_clone.length() > 0) {
                    urlElement = doc.createElement("url");
                    locElement = doc.createElement("loc");
                    locElement.setTextContent(uri_clone);
                    freqElement = doc.createElement("changefreq");
                    freqElement.setTextContent(frequency);
                    urlElement.appendChild(locElement);
                    urlElement.appendChild(freqElement);
                    if (priority >= 0.0f) {
                        priorityElement = doc.createElement("priority");
                        priorityElement.setTextContent(String.valueOf(priority));
                        urlElement.appendChild(priorityElement);
                    }
                    root.appendChild(urlElement);
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            transformer.transform(source, new StreamResult(writer));
            sitemapData = writer.toString();
            sitemapNode.setProperty("jcr:data", sitemapData);
            sitemapNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
        }
        if (sitemapData != null && sitemapData.length() > 0) {
            String hash = this.getSiteMapCacheKey(portalName);
            this.cache.put((Serializable)((Object)hash), (Object)sitemapData);
        }
        session.save();
    }

    public void updateRobots(Node dummyNode, String portalName) throws Exception {
        if (!dummyNode.getNode(METADATA_BASE_PATH).hasNode(ROBOTS_NAME)) {
            dummyNode.getNode(METADATA_BASE_PATH).addNode(ROBOTS_NAME, "nt:file");
            Node robotsFolder = dummyNode.getNode(METADATA_BASE_PATH + "/" + ROBOTS_NAME);
            Node robotsNode = robotsFolder.addNode("jcr:content", "nt:resource");
            robotsNode.setProperty("jcr:mimeType", "text/plain");
            PortalRequestContext ctx = Util.getPortalRequestContext();
            StringBuffer robotsContent = new StringBuffer("# robots.txt \n");
            robotsContent.append("User-agent: * \n");
            robotsContent.append("Disallow: \n");
            if (ctx.getRequest() != null) {
                if (ctx.getRequest().getServerPort() != 80) {
                    robotsContent.append("Sitemap: ").append(ctx.getRequest().getScheme()).append("://").append(ctx.getRequest().getServerName()).append(":").append(ctx.getRequest().getServerPort()).append(ctx.getPortalURI()).append("sitemaps.xml \n");
                } else {
                    robotsContent.append("Sitemap: ").append(ctx.getRequest().getScheme()).append("://").append(ctx.getRequest().getServerName()).append(ctx.getPortalURI()).append("sitemaps.xml \n");
                }
            }
            robotsNode.setProperty("jcr:data", robotsContent.toString());
            robotsNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
            this.cache.put((Serializable)((Object)this.getRobotsCacheKey(portalName)), (Object)robotsContent.toString());
        }
    }

    private String getRobotsCacheKey(String portalName) throws Exception {
        return this.getHash(portalName + ROBOTS_NAME);
    }

    @Override
    public String getSitemap(String portalName) throws Exception {
        String hash = this.getSiteMapCacheKey(portalName);
        String sitemapContent = (String)this.getCachedEntry(hash, false);
        if (sitemapContent == null || sitemapContent.length() == 0) {
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
            Node dummyNode = livePortalManagerService.getLivePortal(sessionProvider, portalName);
            Session session = dummyNode.getSession();
            if (dummyNode.hasNode(METADATA_BASE_PATH) && dummyNode.getNode(METADATA_BASE_PATH).hasNode(SITEMAP_NAME)) {
                Node sitemapFolder = dummyNode.getNode(METADATA_BASE_PATH + "/" + SITEMAP_NAME);
                Node sitemapNode = sitemapFolder.getNode("jcr:content");
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                InputStream stream = sitemapNode.getProperty("jcr:data").getStream();
                Document doc = docBuilder.parse(stream);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StringWriter writer = new StringWriter();
                transformer.transform(source, new StreamResult(writer));
                sitemapContent = writer.toString();
            } else {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("urlset");
                doc.appendChild(rootElement);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StringWriter writer = new StringWriter();
                transformer.transform(source, new StreamResult(writer));
                sitemapContent = writer.toString();
            }
            session.save();
            this.cache.put((Serializable)((Object)hash), (Object)sitemapContent);
        }
        return sitemapContent;
    }

    private String getSiteMapCacheKey(String portalName) throws Exception {
        return this.getHash(portalName + SITEMAP_NAME);
    }

    @Override
    public String getRobots(String portalName) throws Exception {
        String hash = this.getRobotsCacheKey(portalName);
        String robotsCache = (String)this.getCachedEntry(hash, false);
        if (robotsCache != null && robotsCache.trim().length() > 0) {
            return robotsCache;
        }
        StringBuffer robotsContent = null;
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
        Node dummyNode = livePortalManagerService.getLivePortal(sessionProvider, portalName);
        Session session = dummyNode.getSession();
        if (dummyNode.hasNode(METADATA_BASE_PATH) && dummyNode.getNode(METADATA_BASE_PATH).hasNode(ROBOTS_NAME)) {
            Node robotsFolder = dummyNode.getNode(METADATA_BASE_PATH + "/" + ROBOTS_NAME);
            Node robotsNode = robotsFolder.getNode("jcr:content");
            robotsContent = new StringBuffer(robotsNode.getProperty("jcr:data").getValue().getString());
        } else {
            robotsContent = new StringBuffer("# robots.txt \n");
            robotsContent.append("User-agent: * \n");
            robotsContent.append("Disallow: \n");
        }
        session.save();
        this.cache.put((Serializable)((Object)hash), (Object)robotsContent.toString());
        return robotsContent.toString();
    }

    @Override
    public String getHash(String uri) throws Exception {
        String key = uri;
        return MessageDigester.getHash(key);
    }

    private String getStandardURL(String path) throws Exception {
        if (path != null && path.substring(path.length() - 1, path.length()).equals("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    @Override
    public Node getContentNode(String seoPath) throws Exception {
        Node seoNode = null;
        if (seoPath != null && seoPath.length() > 0) {
            String[] arrPath;
            String tmpPath = seoPath.trim();
            if (tmpPath.startsWith("/")) {
                tmpPath = tmpPath.substring(1, tmpPath.length());
            }
            if ((arrPath = tmpPath.split("/")) != null && arrPath.length > 3) {
                String repo = arrPath[0];
                String ws = arrPath[1];
                if (repo != null && ws != null) {
                    boolean isWs = false;
                    String nodePath = tmpPath.substring(tmpPath.indexOf(ws) + ws.length(), tmpPath.length());
                    if (nodePath != null && nodePath.length() > 0) {
                        Session session;
                        ManageableRepository manageRepo = WCMCoreUtils.getRepository();
                        List wsList = manageRepo.getConfiguration().getWorkspaceEntries();
                        for (int i = 0; i < wsList.size(); ++i) {
                            WorkspaceEntry wsEntry = (WorkspaceEntry)wsList.get(i);
                            if (!wsEntry.getName().equals(ws)) continue;
                            isWs = true;
                            break;
                        }
                        if (isWs && (session = WCMCoreUtils.getUserSessionProvider().getSession(ws, manageRepo)).getItem(nodePath = nodePath.replaceAll("//", "/")) != null && session.getItem(nodePath).isNode()) {
                            seoNode = (Node)session.getItem(nodePath);
                        }
                    }
                }
            }
        }
        return seoNode;
    }

    @Managed
    @ManagedDescription(value="Is the cache used ?")
    public boolean isCached() {
        return this.isCached;
    }

    @Managed
    @ManagedDescription(value="How many nodes in the cache ?")
    public int getCachedEntries() {
        return this.cache.getCacheSize();
    }

    @Managed
    @ManagedDescription(value="Activate/deactivate the composer cache ?")
    public void setCached(@ManagedDescription(value="Enable/Disable the cache ?") @ManagedName(value="isCached") boolean isCached) {
        this.isCached = isCached;
    }

    class SEOItemComparator
    implements Comparator<Locale> {
        SEOItemComparator() {
        }

        @Override
        public int compare(Locale locale1, Locale locale2) {
            return locale1.getDisplayName().compareTo(locale2.getDisplayName());
        }
    }
}

