/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.jeuclid;

import java.io.File;
import java.io.OutputStream;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import uk.ac.ed.ph.snuggletex.jeuclid.MathMLImageSavingCallback;

public abstract class SimpleMathMLImageSavingCallback
implements MathMLImageSavingCallback {
    private String fontSize;
    private boolean antiAliasing;
    private String imageContentType;
    private final LayoutContextImpl layoutContext = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());

    public SimpleMathMLImageSavingCallback() {
        this.setFontSize("16.0");
        this.setAntiAliasing(true);
        this.setImageContentType("image/png");
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
        this.layoutContext.setParameter(Parameter.MATHSIZE, (Object)Float.valueOf(fontSize));
    }

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
        this.layoutContext.setParameter(Parameter.ANTIALIAS, (Object)antiAliasing);
    }

    public String getImageContentType() {
        return this.imageContentType;
    }

    public void setImageContentType(String imageType) {
        this.imageContentType = imageType;
    }

    public final String getImageContentType(int mathmlCounter) {
        return this.imageContentType;
    }

    public final MutableLayoutContext getLayoutContext(int mathmlCounter) {
        return this.layoutContext;
    }

    public abstract File getImageOutputFile(int var1);

    public abstract OutputStream getImageOutputStream(int var1);

    public abstract String getImageURL(int var1);

    public void imageSavingSucceeded(Object imageFileOrOutputStream, int mathmlCounter, String contentType) {
    }
}

