/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PPTDocumentReader
extends BaseDocumentReader {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.PPTDocumentReader");

    @Override
    public String[] getMimeTypes() {
        return new String[]{"application/powerpoint", "application/ppt", "application/vnd.ms-powerpoint"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        try {
            PowerPointExtractor ppe;
            if (is.available() == 0) {
                String string = "";
                return string;
            }
            try {
                ppe = new PowerPointExtractor(is);
            }
            catch (IOException e) {
                throw new DocumentReadException("Can't open presentation.", e);
            }
            String string = ppe.getText(true, true);
            return string;
        }
        finally {
            block15: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block15;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
    }

    @Override
    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    @Override
    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        POIPropertiesReader reader = new POIPropertiesReader();
        reader.readDCProperties(is);
        return reader.getProperties();
    }
}

